<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso negado.']);
    exit;
}

$dados = json_decode(file_get_contents('php://input'), true);
$id_agendamento = $dados['id'] ?? 0;
$nova_data_hora = $dados['start'] ?? '';

if ($id_agendamento > 0 && !empty($nova_data_hora)) {
    $stmt = $conexao->prepare("UPDATE agendamentos SET data_hora_agendamento = ? WHERE id = ?");
    $stmt->bind_param("si", $nova_data_hora, $id_agendamento);
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Agendamento reagendado com sucesso.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao reagendar.']);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos para reagendamento.']);
}
$conexao->close();
?>