<?php
// O título da página agora está escrito corretamente e será lido como UTF-8
$titulo_pagina = "Histórico do Paciente"; 
include_once './_template/header.php';
require_once '../conexao.php';

// Busca o paciente
$id = $_GET['id'] ?? 0;
if ($id === 0) {
    // Redireciona se nenhum ID for fornecido
    header("Location: pacientes_listar.php");
    exit();
}

$stmt_paciente = $conexao->prepare("SELECT nome_completo FROM pacientes WHERE id = ?");
$stmt_paciente->bind_param("i", $id);
$stmt_paciente->execute();
$paciente = $stmt_paciente->get_result()->fetch_assoc();
$stmt_paciente->close();

if (!$paciente) {
    // Redireciona se o paciente não for encontrado
    $_SESSION['error_message'] = "Paciente não encontrado.";
    header("Location: pacientes_listar.php");
    exit();
}


// Busca o histórico de agendamentos
$stmt_agendamentos = $conexao->prepare("
    SELECT a.data_hora_agendamento, a.status_agendamento, m.nome_completo as nome_medico, e.nome as nome_especialidade
    FROM agendamentos a
    JOIN medicos m ON a.id_medico = m.id
    JOIN especialidades e ON a.id_especialidade_agendada = e.id
    WHERE a.id_paciente = ? ORDER BY a.data_hora_agendamento DESC");
$stmt_agendamentos->bind_param("i", $id);
$stmt_agendamentos->execute();
$agendamentos = $stmt_agendamentos->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_agendamentos->close();
?>

<h1 class="h3 mb-2 text-gray-800">Histórico de Atendimento</h1> 
<h2 class="h5 mb-4 text-gray-600"><?php echo htmlspecialchars($paciente['nome_completo']); ?></h2>

<div class="card shadow">
    <div class="card-header">
        Consultas Agendadas
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Data/Hora</th>
                        <th>Médico</th>
                        <th>Especialidade</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($agendamentos)): foreach ($agendamentos as $ag): ?>
                        <tr>
                            <td><?php echo date("d/m/Y H:i", strtotime($ag['data_hora_agendamento'])); ?></td>
                            <td><?php echo htmlspecialchars($ag['nome_medico']); ?></td>
                            <td><?php echo htmlspecialchars($ag['nome_especialidade']); ?></td>
                            <td><span class="badge bg-secondary"><?php echo htmlspecialchars($ag['status_agendamento']); ?></span></td>
                        </tr>
                    <?php endforeach; else: ?>
                        <tr><td colspan="4" class="text-center">Nenhum agendamento encontrado para este paciente.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="mt-4">
    <a href="pacientes_listar.php" class="btn btn-secondary">Voltar para a Lista</a>
</div>

<?php 
$conexao->close(); 
include_once './_template/footer.php'; 
?>