<?php
$titulo_pagina = "Gerenciar Especialidades";
include_once './_template/header.php';
require_once '../conexao.php';

// Buscar todas as especialidades
$sql = "SELECT id, nome, descricao FROM especialidades ORDER BY nome";
$resultado = $conexao->query($sql);
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Especialidades</h1>
    <a href="especialidades_adicionar.php" class="btn btn-success">
        <i class="bi bi-plus-lg"></i> Adicionar Nova
    </a>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success_message']; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['success_message']); ?>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Lista de Especialidades Cadastradas</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nome</th>
                        <th>Descrição</th>
                        <th class="text-center">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resultado->num_rows > 0): ?>
                        <?php while($especialidade = $resultado->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $especialidade['id']; ?></td>
                                <td><?php echo htmlspecialchars($especialidade['nome']); ?></td>
                                <td><?php echo htmlspecialchars($especialidade['descricao']); ?></td>
                                <td class="text-center">
                                    <a href="especialidades_editar.php?id=<?php echo $especialidade['id']; ?>" class="btn btn-warning btn-sm" title="Editar">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <a href="especialidades_acao.php?acao=excluir&id=<?php echo $especialidade['id']; ?>" class="btn btn-danger btn-sm" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir?');">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">Nenhuma especialidade encontrada.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>