<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit();
}

require_once '../conexao.php';

$acao = $_POST['acao'] ?? $_GET['acao'] ?? '';

switch ($acao) {
    case 'adicionar':
        $numero_sala = $_POST['numero_sala'];
        $descricao = $_POST['descricao'];
        
        $sql = "INSERT INTO consultorios (numero_sala, descricao) VALUES (?, ?)";
        $stmt = $conexao->prepare($sql);
        $stmt->bind_param("ss", $numero_sala, $descricao);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Consultório adicionado com sucesso!";
        }
        $stmt->close();
        break;

    case 'editar':
        $id = $_POST['id'];
        $numero_sala = $_POST['numero_sala'];
        $descricao = $_POST['descricao'];
        
        $sql = "UPDATE consultorios SET numero_sala = ?, descricao = ? WHERE id = ?";
        $stmt = $conexao->prepare($sql);
        $stmt->bind_param("ssi", $numero_sala, $descricao, $id);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Consultório atualizado com sucesso!";
        }
        $stmt->close();
        break;

    case 'excluir':
        $id = $_GET['id'];
        
        $sql = "DELETE FROM consultorios WHERE id = ?";
        $stmt = $conexao->prepare($sql);
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Consultório excluído com sucesso!";
        }
        $stmt->close();
        break;
}

$conexao->close();

header("Location: consultorios_listar.php");
exit();
?>