<?php
session_start();
if (!isset($_SESSION['medico_id'])) {
    header("Location: index.php");
    exit();
}
$nome_medico = $_SESSION['medico_nome'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sua Fila de Atendimento - CliniSys</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root {
            --primary-color: #2563eb;
            --success-color: #16a34a;
            --warning-color: #ca8a04;
            --danger-color: #dc2626;
            --gray-100: #f3f4f6;
            --gray-200: #e5e7eb;
            --gray-300: #d1d5db;
        }

        body { 
            background-color: var(--gray-100);
            font-family: 'Inter', system-ui, -apple-system, sans-serif;
        }

        .navbar {
            background: linear-gradient(135deg, var(--primary-color), #1d4ed8);
            padding: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .navbar-brand {
            font-weight: 600;
            font-size: 1.25rem;
        }

        .container {
            max-width: 768px;
            padding: 1rem;
        }

        .card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1), 0 2px 4px -1px rgba(0,0,0,0.06);
            margin-bottom: 1rem;
            overflow: hidden;
        }

        .card-header {
            border-bottom: none;
            padding: 1rem 1.5rem;
            font-weight: 600;
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .card-body {
            padding: 1.5rem;
        }

        .priority-badge {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 0.5rem;
        }

        .priority-4 { border-left: 4px solid var(--danger-color); }
        .priority-3 { border-left: 4px solid var(--warning-color); }
        .priority-2 { border-left: 4px solid var(--success-color); }

        .btn {
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 0.75rem;
            transition: all 0.2s;
        }

        .btn-lg {
            padding: 1rem 2rem;
        }

        .btn-primary {
            background: var(--primary-color);
            border: none;
        }

        .btn-primary:hover {
            background: #1d4ed8;
            transform: translateY(-1px);
        }

        .btn-success {
            background: var(--success-color);
            border: none;
        }

        .btn-success:hover {
            background: #15803d;
            transform: translateY(-1px);
        }

        .patient-name {
            font-size: 1.25rem;
            font-weight: 600;
            color: #1f2937;
            margin: 0;
        }

        .patient-info {
            color: #6b7280;
            font-size: 0.875rem;
            margin-top: 0.5rem;
        }

        .status-badge {
            font-size: 0.75rem;
            font-weight: 500;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .status-waiting {
            background-color: var(--gray-200);
            color: #4b5563;
        }

        .status-called {
            background-color: #dbeafe;
            color: #1e40af;
        }

        .status-attending {
            background-color: #dcfce7;
            color: #166534;
        }

        .action-buttons {
            display: flex;
            gap: 0.5rem;
            margin-top: 1rem;
        }

        .patient-card {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 1rem;
            background: white;
            border-radius: 0.75rem;
            margin-bottom: 0.5rem;
            transition: all 0.2s;
        }

        .patient-card:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1);
        }

        .patient-info-container {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .patient-details {
            display: flex;
            flex-direction: column;
        }

        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
            color: #6b7280;
        }

        .empty-state i {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: var(--gray-300);
        }

        @media (max-width: 576px) {
            .container {
                padding: 0.5rem;
            }

            .card-body {
                padding: 1rem;
            }

            .btn {
                padding: 0.5rem 1rem;
            }

            .patient-name {
                font-size: 1rem;
            }

            .patient-info {
                font-size: 0.75rem;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="bi bi-heart-pulse-fill me-2"></i>CliniSys
            </a>
            <span class="text-white-50">Dr(a). <?php echo htmlspecialchars($nome_medico); ?></span>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Sair</a>
        </div>
    </nav>

    <div class="container">
        <div id="area_atendimento_atual"></div>
        <div id="area_proximo_paciente"></div>
        
        <h4 class="text-muted mb-3" id="titulo_fila_espera" style="display: none;">Aguardando na Fila</h4>
        <div id="lista_espera_restante"></div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const areaAtendimento = document.getElementById('area_atendimento_atual');
    const areaProximo = document.getElementById('area_proximo_paciente');
    const areaRestante = document.getElementById('lista_espera_restante');
    const tituloFilaEspera = document.getElementById('titulo_fila_espera');

    const prioridades = {
        '4': { cor: 'danger' },
        '3': { cor: 'warning' },
        '2': { cor: 'success' }
    };

    function getPriorityBadge(level) {
        if (prioridades[level]) {
            return `<span class="priority-badge bg-${prioridades[level].cor}"></span>`;
        }
        return '';
    }

    function formatarHora(dataHora) {
        return new Date(dataHora).toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
    }

    function renderizarFila(fila) {
        let pacienteEmAtendimento = fila.find(p => p.status_fila === 'Em Atendimento');
        let pacienteChamado = fila.find(p => p.status_fila === 'Chamado');
        let aguardando = fila.filter(p => p.status_fila === 'Aguardando');
        
        areaAtendimento.innerHTML = '';
        areaProximo.innerHTML = '';
        areaRestante.innerHTML = '';
        tituloFilaEspera.style.display = 'none';

        if (pacienteEmAtendimento) {
            const card = `
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <i class="bi bi-person-check-fill me-2"></i>Em Atendimento
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            ${getPriorityBadge(pacienteEmAtendimento.ordem_prioridade)}
                            <h2 class="patient-name">${pacienteEmAtendimento.nome_paciente}</h2>
                        </div>
                        <div class="patient-info">
                            <div><i class="bi bi-clock me-2"></i>Horário Agendado: ${formatarHora(pacienteEmAtendimento.data_hora_agendamento)}</div>
                        </div>
                        <div class="action-buttons">
                            <button class="btn btn-success btn-lg flex-grow-1" onclick="atualizarStatus(${pacienteEmAtendimento.id_fila}, 'Atendido', true)">
                                <i class="bi bi-check-circle-fill me-2"></i>Finalizar e Chamar Próximo
                            </button>
                            <button class="btn btn-outline-secondary" onclick="atualizarStatus(${pacienteEmAtendimento.id_fila}, 'Atendido', false)">
                                <i class="bi bi-x-circle me-2"></i>Finalizar
                            </button>
                        </div>
                    </div>
                </div>`;
            areaAtendimento.innerHTML = card;
        }
        else if (pacienteChamado) {
            const card = `
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <i class="bi bi-megaphone-fill me-2"></i>Paciente Chamado
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            ${getPriorityBadge(pacienteChamado.ordem_prioridade)}
                            <h2 class="patient-name">${pacienteChamado.nome_paciente}</h2>
                        </div>
                        <div class="patient-info">
                            <div><i class="bi bi-clock me-2"></i>Horário Agendado: ${formatarHora(pacienteChamado.data_hora_agendamento)}</div>
                            <div class="mt-2"><i class="bi bi-info-circle me-2"></i>Aguardando paciente no consultório...</div>
                        </div>
                        <div class="action-buttons">
                            <button class="btn btn-primary btn-lg flex-grow-1" onclick="atualizarStatus(${pacienteChamado.id_fila}, 'Em Atendimento')">
                                <i class="bi bi-play-circle-fill me-2"></i>Iniciar Atendimento
                            </button>
                            <button class="btn btn-outline-primary" onclick="atualizarStatus(${pacienteChamado.id_fila}, 'Chamado')">
                                <i class="bi bi-megaphone me-2"></i>Chamar Novamente
                            </button>
                        </div>
                    </div>
                </div>`;
            areaAtendimento.innerHTML = card;
        }
        
        if (aguardando.length > 0) {
            const proximo = aguardando.shift(); 
            const card = `
                <div class="card priority-${proximo.ordem_prioridade}">
                    <div class="card-header bg-white">
                        <i class="bi bi-person-fill me-2"></i>Próximo Paciente
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            ${getPriorityBadge(proximo.ordem_prioridade)}
                            <h2 class="patient-name">${proximo.nome_paciente}</h2>
                        </div>
                        <div class="patient-info">
                            <div><i class="bi bi-clock me-2"></i>Horário Agendado: ${formatarHora(proximo.data_hora_agendamento)}</div>
                            <div class="mt-2"><i class="bi bi-clock-history me-2"></i>Chegada: ${new Date(proximo.hora_chegada).toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' })}</div>
                        </div>
                        <button class="btn btn-primary btn-lg w-100 mt-3" onclick="atualizarStatus(${proximo.id_fila}, 'Chamado')">
                            <i class="bi bi-megaphone-fill me-2"></i>Chamar Paciente
                        </button>
                    </div>
                </div>`;
            areaProximo.innerHTML = card;

            tituloFilaEspera.style.display = 'block';
            aguardando.forEach(paciente => {
                const card = `
                    <div class="patient-card priority-${paciente.ordem_prioridade}">
                        <div class="patient-info-container">
                            ${getPriorityBadge(paciente.ordem_prioridade)}
                            <div class="patient-details">
                                <h5 class="patient-name mb-1">${paciente.nome_paciente}</h5>
                                <div class="patient-info">
                                    <i class="bi bi-clock me-1"></i>${formatarHora(paciente.data_hora_agendamento)}
                                </div>
                            </div>
                        </div>
                        <button class="btn btn-outline-primary btn-sm" onclick="atualizarStatus(${paciente.id_fila}, 'Chamado')">
                            <i class="bi bi-megaphone me-2"></i>Chamar
                        </button>
                    </div>`;
                areaRestante.innerHTML += card;
            });
        } else if (!pacienteEmAtendimento && !pacienteChamado && areaProximo.innerHTML === '') {
            areaRestante.innerHTML = `
                <div class="empty-state">
                    <i class="bi bi-emoji-smile"></i>
                    <h4>Nenhum paciente aguardando</h4>
                    <p class="text-muted">A fila está vazia no momento</p>
                </div>`;
        }
    }

    window.atualizarFila = function() {
        fetch('../api/get_fila_medico.php')
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    areaRestante.innerHTML = `<div class="alert alert-danger">${data.error}</div>`;
                    return;
                }
                renderizarFila(data);
            });
    }

    window.atualizarStatus = function(idFila, novoStatus, chamarProximo = false) {
        const confirmMsg = `Tem certeza que deseja alterar o status para "${novoStatus}"?`;
        if (novoStatus !== 'Chamado' && novoStatus !== 'Em Atendimento' && !confirm(confirmMsg)) return;

        fetch('../api/atualizar_status_fila.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ 
                id_fila: idFila, 
                novo_status: novoStatus,
                chamar_proximo: chamarProximo
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                atualizarFila();
            } else {
                alert('Erro: ' + data.message);
            }
        });
    }

    // Adiciona listener para o evento de reordenação
    window.addEventListener('filaReordenada', function(e) {
        atualizarFila();
    });

    atualizarFila();
    setInterval(atualizarFila, 5000);
});
</script>
</body>
</html>