<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

// Função para gerar uma cor consistente para cada médico
function gerarCorPorId($id) {
    $hash = crc32("medico_id_" . $id);
    $r = ($hash & 0xFF0000) >> 16;
    $g = ($hash & 0x00FF00) >> 8;
    $b = $hash & 0x0000FF;
    // Garante cores mais escuras para o texto branco ficar legível
    $r = floor($r * 0.75); $g = floor($g * 0.75); $b = floor($b * 0.75);
    return sprintf('#%02x%02x%02x', $r, $g, $b);
}

// SQL para buscar todos os agendamentos
$medico_id = $_GET['medico_id'] ?? 'todos';
$sql = "SELECT 
            a.id,
            a.data_hora_agendamento as start,
            DATE_ADD(a.data_hora_agendamento, INTERVAL m.duracao_consulta_min MINUTE) as end,
            p.nome_completo as nome_paciente,
            m.nome_completo as nome_medico,
            a.id_medico,
            a.id_paciente,
            a.id_especialidade_agendada as id_especialidade,
            e.nome as especialidade,
            a.status_agendamento as status,
            p.telefone_contato as telefone_paciente
        FROM 
            agendamentos a
        INNER JOIN 
            pacientes p ON a.id_paciente = p.id
        INNER JOIN 
            medicos m ON a.id_medico = m.id
        INNER JOIN
            especialidades e ON a.id_especialidade_agendada = e.id
        WHERE 
            m.ativo = 1";

if ($medico_id !== 'todos') {
    $sql .= " AND a.id_medico = " . intval($medico_id);
}

$sql .= " ORDER BY a.data_hora_agendamento ASC";

$resultado = $conexao->query($sql);
$agendamentos = [];

if ($resultado) {
    // Mapeamento dos status do banco para os nomes do frontend
    $status_map = [
        'Agendado' => 'agendado',
        'Confirmado' => 'confirmado',
        'Cancelado' => 'cancelado',
        'Realizado' => 'atendimento',
        'NaoCompareceu' => 'nao_compareceu',
        'Aguardando' => 'fila',
    ];
    while ($ag = $resultado->fetch_assoc()) {
        $status_banco = $ag['status'] ?? '';
        $status_front = isset($status_map[$status_banco]) ? $status_map[$status_banco] : 'agendado';
        $ag['title'] = sprintf(
            "%s\nDr(a). %s - %s",
            mb_strtoupper($ag['nome_paciente'], 'UTF-8'),
            $ag['nome_medico'],
            $ag['especialidade']
        );
        unset($ag['status']); // Remove o campo status do array
        $ag['extendedProps'] = [
            'status' => $status_front,
            'nome_medico' => $ag['nome_medico'],
            'telefone' => $ag['telefone_paciente'],
            'id_medico' => $ag['id_medico'],
            'id_paciente' => $ag['id_paciente'],
            'id_especialidade' => $ag['id_especialidade']
        ];
        $agendamentos[] = $ag;
    }
}

$conexao->close();
echo json_encode($agendamentos);
?>