<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

$idMedico = $_GET['medico_id'] ?? 0;
$data_str = $_GET['data'] ?? '';
$slots = [];

if ($idMedico > 0 && !empty($data_str)) {
    $dia_selecionado = new DateTime($data_str);
    $dia_semana_num = $dia_selecionado->format('N') + 1;
    if ($dia_semana_num > 7) $dia_semana_num = 1;

    // Busca jornada de trabalho para aquele dia
    $stmt_jornada = $conexao->prepare("SELECT hora_inicio, hora_fim FROM horarios_trabalho WHERE id_medico = ? AND dia_semana = ? AND ativo = 1");
    $stmt_jornada->bind_param("ii", $idMedico, $dia_semana_num);
    $stmt_jornada->execute();
    $jornada = $stmt_jornada->get_result()->fetch_assoc();
    $stmt_jornada->close();

    if ($jornada) {
        // Busca agendamentos existentes para aquele dia
        $stmt_agendados = $conexao->prepare("SELECT TIME(data_hora_agendamento) as hora FROM agendamentos WHERE id_medico = ? AND DATE(data_hora_agendamento) = ?");
        $stmt_agendados->bind_param("is", $idMedico, $data_str);
        $stmt_agendados->execute();
        $horarios_ocupados = [];
        $resultado_agendados = $stmt_agendados->get_result();
        while($row = $resultado_agendados->fetch_assoc()) {
            $horarios_ocupados[] = $row['hora'];
        }
        $stmt_agendados->close();

        // Gera slots
        $stmt_medico = $conexao->prepare("SELECT duracao_consulta_min FROM medicos WHERE id = ?");
        $stmt_medico->bind_param("i", $idMedico);
        $stmt_medico->execute();
        $duracao_slot = $stmt_medico->get_result()->fetch_assoc()['duracao_consulta_min'] ?? 30;
        $stmt_medico->close();

        $hora_inicio_jornada = new DateTime($jornada['hora_inicio']);
        $hora_fim_jornada = new DateTime($jornada['hora_fim']);
        
        while ($hora_inicio_jornada < $hora_fim_jornada) {
            $slot_formatado_db = $hora_inicio_jornada->format('H:i:s');
            if (!in_array($slot_formatado_db, $horarios_ocupados)) {
                $slots[] = $hora_inicio_jornada->format('H:i');
            }
            $hora_inicio_jornada->add(new DateInterval('PT' . $duracao_slot . 'M'));
        }
    }
}
echo json_encode($slots ?? []);
?>