<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['medico_id'])) {
    echo json_encode(['error' => 'Acesso não autorizado']);
    exit;
}

require_once '../conexao.php';

$idMedico = $_SESSION['medico_id'];

$sql = "SELECT 
            f.id as id_fila,
            p.nome_completo as nome_paciente,
            f.hora_chegada,
            f.status_fila,
            f.ordem_prioridade,
            f.ordem_manual,
            a.data_hora_agendamento 
        FROM 
            fila_espera f
        JOIN 
            agendamentos a ON f.id_agendamento = a.id
        JOIN
            pacientes p ON a.id_paciente = p.id
        WHERE 
            f.id_medico = ? 
            AND f.status_fila IN ('Aguardando', 'Chamado', 'Em Atendimento')
            AND NOT EXISTS (
                SELECT 1 FROM fila_espera f2 
                WHERE f2.id_agendamento = f.id_agendamento 
                AND f2.status_fila = 'Em Atendimento'
                AND f2.id != f.id
            )
        ORDER BY 
            f.status_fila = 'Em Atendimento' DESC,
            f.status_fila = 'Chamado' DESC,
            f.ordem_manual ASC,
            f.ordem_prioridade DESC,
            f.hora_chegada ASC";

try {
    $stmt = $conexao->prepare($sql);
    $stmt->bind_param("i", $idMedico);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $fila = $resultado->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    $conexao->close();

    echo json_encode($fila);
} catch (Exception $e) {
    echo json_encode(['error' => 'Erro ao buscar fila: ' . $e->getMessage()]);
}
?>