<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['medico_id'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado.']);
    exit;
}

require_once '../conexao.php';

$dados = json_decode(file_get_contents('php://input'), true);
$idFila = $dados['id_fila'] ?? 0;
$novoStatus = $dados['novo_status'] ?? '';
$idMedicoLogado = $_SESSION['medico_id'];

if ($idFila === 0 || !in_array($novoStatus, ['Chamado', 'Em Atendimento', 'Atendido'])) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
    exit;
}

$conexao->begin_transaction();
try {
    $hora_atual = date('Y-m-d H:i:s');
    $coluna_hora = '';
    $mensagem_sucesso = '';

    switch ($novoStatus) {
        case 'Chamado':
            // Retorna pacientes chamados anteriores para a fila, garantindo que voltem para Aguardando na Fila
            $sql_retornar = "UPDATE fila_espera 
                            SET status_fila = 'Aguardando',
                                ordem_manual = 999999
                            WHERE id_medico = ? 
                            AND status_fila = 'Chamado'";
            $stmt_retornar = $conexao->prepare($sql_retornar);
            $stmt_retornar->bind_param("i", $idMedicoLogado);
            $stmt_retornar->execute();

            $coluna_hora = 'hora_chamada';
            $mensagem_sucesso = 'Paciente chamado com sucesso!';

            // Insere o registro na tabela de chamadas da TV
            $sql_info = "SELECT p.nome_completo, c.numero_sala FROM fila_espera f 
                         JOIN agendamentos a ON f.id_agendamento = a.id
                         JOIN pacientes p ON a.id_paciente = p.id
                         JOIN consultorios c ON f.id_consultorio = c.id
                         WHERE f.id = ? AND f.id_medico = ?";
            $stmt_info = $conexao->prepare($sql_info);
            $stmt_info->bind_param("ii", $idFila, $idMedicoLogado);
            $stmt_info->execute();
            $info = $stmt_info->get_result()->fetch_assoc();
            
            if ($info) {
                $stmt_tv = $conexao->prepare("INSERT INTO chamadas_tv (nome_paciente, numero_consultorio) VALUES (?, ?)");
                $stmt_tv->bind_param("ss", $info['nome_completo'], $info['numero_sala']);
                $stmt_tv->execute();
            }
            break;
        case 'Em Atendimento':
            // Primeiro, pega o paciente que está chamado
            $sql_chamado = "SELECT id FROM fila_espera 
                           WHERE id_medico = ? 
                           AND status_fila = 'Chamado'
                           LIMIT 1";
            $stmt_chamado = $conexao->prepare($sql_chamado);
            $stmt_chamado->bind_param("i", $idMedicoLogado);
            $stmt_chamado->execute();
            $resultado_chamado = $stmt_chamado->get_result();
            $paciente_chamado = $resultado_chamado->fetch_assoc();

            if ($paciente_chamado) {
                // Se tem paciente chamado, mantém ele chamado e retorna o novo paciente para a fila
                $sql_retornar = "UPDATE fila_espera 
                                SET status_fila = 'Aguardando' 
                                WHERE id = ?";
                $stmt_retornar = $conexao->prepare($sql_retornar);
                $stmt_retornar->bind_param("i", $idFila);
                $stmt_retornar->execute();

                // Atualiza o status do paciente chamado para Em Atendimento
                $sql_atualiza = "UPDATE fila_espera 
                                SET status_fila = 'Em Atendimento' 
                                WHERE id = ?";
                $stmt_atualiza = $conexao->prepare($sql_atualiza);
                $stmt_atualiza->bind_param("i", $paciente_chamado['id']);
                $stmt_atualiza->execute();

                // Retorna o ID do paciente que realmente será atendido
                $idFila = $paciente_chamado['id'];
            }

            // Não precisamos atualizar nenhuma coluna de hora específica aqui, apenas o status.
            // A hora_chamada já foi registrada.
            $mensagem_sucesso = 'Atendimento iniciado.';
            break;
        case 'Atendido':
            $coluna_hora = 'hora_fim_atendimento';
            $mensagem_sucesso = 'Atendimento finalizado com sucesso.';
            break;
    }

    $sql_update = "UPDATE fila_espera SET status_fila = ?";
    if (!empty($coluna_hora)) {
        $sql_update .= ", $coluna_hora = ?";
        $stmt_update = $conexao->prepare($sql_update . " WHERE id = ? AND id_medico = ?");
        $stmt_update->bind_param("ssii", $novoStatus, $hora_atual, $idFila, $idMedicoLogado);
    } else {
        $stmt_update = $conexao->prepare($sql_update . " WHERE id = ? AND id_medico = ?");
        $stmt_update->bind_param("sii", $novoStatus, $idFila, $idMedicoLogado);
    }
    
    $stmt_update->execute();
    
    $conexao->commit();
    echo json_encode(['success' => true, 'message' => $mensagem_sucesso]);

} catch (Exception $e) {
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => 'Erro ao atualizar status: ' . $e->getMessage()]);
}

$conexao->close();
?>