<?php
$titulo_pagina = "Gerenciar Pacientes";
include_once './_template/header.php';
require_once '../conexao.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Gerenciar Pacientes</h1>
    <a href="pacientes_adicionar.php" class="btn btn-success"><i class="bi bi-plus-lg"></i> Adicionar Paciente</a>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <div class="row">
            <div class="col-md-6">
                <select id="buscaPaciente" class="form-control" style="width: 100%;">
                    <option></option>
                </select>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Idade</th>
                        <th>CPF</th>
                        <th>Celular</th>
                        <th class="acoes-header">Ações</th>
                    </tr>
                </thead>
                <tbody id="tabelaPacientes">
                    <tr>
                        <td colspan="5" class="text-center">Digite algo para buscar pacientes...</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
    .acoes-botoes {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 4px;
    }
    .acoes-botoes .btn {
        padding: 0.25rem 0.5rem;
        font-size: 1.1rem;
        border-radius: 0.25rem;
        box-shadow: none;
        background: none;
        border: none;
        color: inherit;
    }
    .acoes-botoes .btn:hover {
        background: #f0f0f0;
    }
    .icon-whatsapp { color: #25d366; }
    .icon-agendar { color: #2563eb; }
    .icon-editar { color: #f59e42; }
    .icon-prontuario { color: #06b6d4; }
    th.acoes-header, td.acoes-cell {
        text-align: center;
        vertical-align: middle !important;
        width: 140px;
    }
</style>

<script>
$(document).ready(function() {
    $('#buscaPaciente').select2({
        theme: 'bootstrap-5',
        placeholder: 'Digite nome, CPF ou celular...',
        language: {
            inputTooShort: function() {
                return 'Digite pelo menos 2 caracteres';
            },
            noResults: function() {
                return 'Nenhum resultado encontrado';
            },
            searching: function() {
                return 'Buscando...';
            },
            loadingMore: function() {
                return 'Carregando mais resultados...';
            },
            errorLoading: function() {
                return 'Erro ao carregar resultados';
            }
        },
        ajax: {
            url: '../api/get_pacientes_simplificado.php',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    term: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data.results
                };
            },
            cache: true
        }
    });

    // Função para calcular idade
    function calcularIdade(dataNascimento) {
        if (!dataNascimento) return '-';
        const hoje = new Date();
        const nascimento = new Date(dataNascimento);
        let idade = hoje.getFullYear() - nascimento.getFullYear();
        const mesAtual = hoje.getMonth();
        const mesNascimento = nascimento.getMonth();
        
        if (mesAtual < mesNascimento || (mesAtual === mesNascimento && hoje.getDate() < nascimento.getDate())) {
            idade--;
        }
        
        return idade + ' anos';
    }

    // Função para formatar número do WhatsApp
    function formatarWhatsApp(telefone) {
        if (!telefone) return '-';
        // Remove tudo que não for número
        const numero = telefone.replace(/\D/g, '');
        // Adiciona o código do país se não tiver
        return numero.length === 11 ? '55' + numero : numero;
    }

    // Atualizar tabela quando selecionar um paciente
    $('#buscaPaciente').on('select2:select', function(e) {
        const paciente = e.params.data;
        const tbody = document.getElementById('tabelaPacientes');
        const whatsapp = formatarWhatsApp(paciente.telefone);
        
        tbody.innerHTML = `
            <tr>
                <td>${paciente.text.split(' (')[0]}</td>
                <td>${calcularIdade(paciente.data_nascimento)}</td>
                <td>${paciente.text.split('(')[1].replace(')', '')}</td>
                <td>${paciente.telefone || '-'}</td>
                <td class="acoes-cell">
                    <div class="acoes-botoes">
                        <a href="https://wa.me/${whatsapp}" target="_blank" class="btn btn-sm" title="WhatsApp"><i class="bi bi-whatsapp icon-whatsapp"></i></a>
                        <a href="agendamento_admin.php?paciente_id=${paciente.id}" class="btn btn-sm" title="Agendar"><i class="bi bi-calendar2-plus icon-agendar"></i></a>
                        <a href="pacientes_editar.php?id=${paciente.id}" class="btn btn-sm" title="Editar"><i class="bi bi-person-lines-fill icon-editar"></i></a>
                        <a href="pacientes_prontuario.php?id=${paciente.id}" class="btn btn-sm" title="Prontuário"><i class="bi bi-journal-medical icon-prontuario"></i></a>
                    </div>
                </td>
            </tr>
        `;
    });

    // Limpar busca e mostrar mensagem inicial
    $('#buscaPaciente').on('select2:clear', function() {
        const tbody = document.getElementById('tabelaPacientes');
        tbody.innerHTML = '<tr><td colspan="5" class="text-center">Digite um nome para buscar ou deixe em branco para ver todos os pacientes.</td></tr>';
    });

    function carregarTabela(pacientes) {
        const tbody = document.getElementById('tabelaPacientes');
        
        if (!pacientes || pacientes.length === 0) {
            tbody.innerHTML = '<tr><td colspan="5" class="text-center">Nenhum paciente encontrado</td></tr>';
            return;
        }
        
        tbody.innerHTML = pacientes.map(paciente => `
            <tr>
                <td>${paciente.nome_completo}</td>
                <td>${calcularIdade(paciente.data_nascimento)}</td>
                <td>${paciente.cpf || '-'}</td>
                <td>${paciente.telefone || '-'}</td>
                <td class="acoes-cell">
                    <div class="acoes-botoes">
                        <a href="https://wa.me/${formatarWhatsApp(paciente.telefone)}" target="_blank" class="btn btn-sm" title="WhatsApp"><i class="bi bi-whatsapp icon-whatsapp"></i></a>
                        <a href="agendamento_admin.php?paciente_id=${paciente.id}" class="btn btn-sm" title="Agendar"><i class="bi bi-calendar2-plus icon-agendar"></i></a>
                        <a href="pacientes_editar.php?id=${paciente.id}" class="btn btn-sm" title="Editar"><i class="bi bi-person-lines-fill icon-editar"></i></a>
                        <a href="pacientes_prontuario.php?id=${paciente.id}" class="btn btn-sm" title="Prontuário"><i class="bi bi-journal-medical icon-prontuario"></i></a>
                    </div>
                </td>
            </tr>
        `).join('');
    }
});
</script>

<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>