<?php
session_start();
if (!isset($_SESSION['admin_id'])) { header("Location: index.php"); exit(); }
require_once '../conexao.php';

$acao = $_POST['acao'] ?? 'adicionar';

// Coleta todos os dados do formulário, tratando campos vazios como NULL
$dados_paciente = [
    'nome_completo' => $_POST['nome_completo'] ?? null,
    'data_nascimento' => empty($_POST['data_nascimento']) ? null : $_POST['data_nascimento'],
    'cpf' => $_POST['cpf'] ?? null,
    'rg' => $_POST['rg'] ?? null,
    'sexo' => $_POST['sexo'] ?? null,
    'estado_civil' => $_POST['estado_civil'] ?? null,
    'nacionalidade' => $_POST['nacionalidade'] ?? null,
    'nome_mae' => $_POST['nome_mae'] ?? null,
    'telefone_contato' => $_POST['telefone_contato'] ?? null,
    'telefone_alternativo' => $_POST['telefone_alternativo'] ?? null,
    'email' => $_POST['email'] ?? null,
    'cep' => $_POST['cep'] ?? null,
    'endereco' => $_POST['endereco'] ?? null,
    'bairro' => $_POST['bairro'] ?? null,
    'cidade' => $_POST['cidade'] ?? null,
    'estado' => $_POST['estado'] ?? null,
    'observacoes_medicas' => $_POST['observacoes_medicas'] ?? null,
    'responsavel_nome' => $_POST['responsavel_nome'] ?? null,
    'responsavel_cpf' => $_POST['responsavel_cpf'] ?? null,
    'responsavel_parentesco' => $_POST['responsavel_parentesco'] ?? null,
    'responsavel_contato' => $_POST['responsavel_contato'] ?? null,
    'tipo_sanguineo' => $_POST['tipo_sanguineo'] ?? null,
    'alergias' => $_POST['alergias'] ?? null,
    'doencas_cronicas' => $_POST['doencas_cronicas'] ?? null,
    'medicacoes_continuas' => $_POST['medicacoes_continuas'] ?? null,
    'historico_cirurgias' => $_POST['historico_cirurgias'] ?? null,
    'plano_saude_nome' => $_POST['plano_saude_nome'] ?? null,
    'plano_saude_numero' => $_POST['plano_saude_numero'] ?? null,
    'plano_saude_validade' => empty($_POST['plano_saude_validade']) ? null : $_POST['plano_saude_validade']
];

if ($acao == 'adicionar') {
    // Monta a query de inserção dinamicamente
    $colunas = implode(', ', array_keys($dados_paciente));
    $placeholders = implode(', ', array_fill(0, count($dados_paciente), '?'));
    $sql = "INSERT INTO pacientes ($colunas) VALUES ($placeholders)";
    
    $stmt = $conexao->prepare($sql);
    $tipos = str_repeat('s', count($dados_paciente)); // Assume todos como string para simplificar
    $stmt->bind_param($tipos, ...array_values($dados_paciente));
    
    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Paciente adicionado com sucesso!";
    } else {
        $_SESSION['error_message'] = "Erro ao adicionar paciente: " . $stmt->error;
    }

} elseif ($acao == 'editar') {
    $id = $_POST['id'];
    $dados_paciente['id'] = $id;

    $sets = [];
    foreach ($dados_paciente as $coluna => $valor) {
        if ($coluna !== 'id') {
            $sets[] = "$coluna = ?";
        }
    }
    $sql = "UPDATE pacientes SET " . implode(', ', $sets) . " WHERE id = ?";

    $stmt = $conexao->prepare($sql);
    $tipos = str_repeat('s', count($dados_paciente) - 1) . 'i'; // s para strings, i para o ID no final
    $valores = array_values($dados_paciente);
    $stmt->bind_param($tipos, ...$valores);
    
    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Paciente atualizado com sucesso!";
    } else {
        $_SESSION['error_message'] = "Erro ao atualizar paciente: " . $stmt->error;
    }
}

$conexao->close();
header("Location: pacientes_listar.php");
exit();
?>