<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit();
}
require_once '../conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_medico = $_POST['id_medico'];
    $horarios = $_POST['horarios'];

    $conexao->begin_transaction();
    try {
        // 1. Limpa a agenda antiga deste médico para evitar lixo
        $stmt_delete = $conexao->prepare("DELETE FROM horarios_trabalho WHERE id_medico = ?");
        $stmt_delete->bind_param("i", $id_medico);
        $stmt_delete->execute();
        $stmt_delete->close();
        
        // 2. Insere os novos horários
        $sql = "INSERT INTO horarios_trabalho (id_medico, dia_semana, hora_inicio, hora_fim) VALUES (?, ?, ?, ?)";
        $stmt_insert = $conexao->prepare($sql);

        foreach ($horarios as $dia_semana => $horas) {
            $inicio = $horas['inicio'];
            $fim = $horas['fim'];
            
            // Só insere se ambos os campos (início e fim) estiverem preenchidos
            if (!empty($inicio) && !empty($fim)) {
                $stmt_insert->bind_param("isss", $id_medico, $dia_semana, $inicio, $fim);
                $stmt_insert->execute();
            }
        }
        $stmt_insert->close();
        
        $conexao->commit();
        $_SESSION['success_message'] = "Jornada de trabalho salva com sucesso!";

    } catch (Exception $e) {
        $conexao->rollback();
        // Tratar erro aqui
    }
    
    $conexao->close();
    header("Location: medicos_horarios.php?medico_id=" . $id_medico);
    exit();
}
?>