<?php
$titulo_pagina = "Gestão da Fila de Espera";
include_once './_template/header.php';
require_once '../conexao.php';

// Busca a fila de todos os médicos que estão aguardando
$sql = "SELECT 
            f.id as id_fila,
            p.nome_completo as nome_paciente,
            m.nome_completo as nome_medico,
            f.ordem_prioridade,
            f.ordem_manual,
            m.id as id_medico
        FROM 
            fila_espera f
        JOIN 
            agendamentos a ON f.id_agendamento = a.id
        JOIN
            pacientes p ON a.id_paciente = p.id
        JOIN
            medicos m ON f.id_medico = m.id
        WHERE 
            f.status_fila = 'Aguardando'
        ORDER BY 
            m.nome_completo, 
            f.ordem_manual ASC, 
            f.ordem_prioridade DESC, 
            f.hora_chegada ASC";
            
$resultado = $conexao->query($sql);

// Agrupa os pacientes por médico
$filas_por_medico = [];
while ($paciente = $resultado->fetch_assoc()) {
    $filas_por_medico[$paciente['nome_medico']][] = $paciente;
}
?>

<h1 class="h3 mb-4 text-gray-800">Gestão da Fila de Espera</h1>
<div id="status-salvamento" class="alert" style="display:none;"></div>

<div class="row">
    <?php if (empty($filas_por_medico)): ?>
        <div class="col-12">
            <div class="alert alert-success text-center">Nenhum paciente na fila de espera no momento.</div>
        </div>
    <?php else: ?>
        <?php foreach ($filas_por_medico as $nome_medico => $fila): ?>
            <div class="col-md-6 mb-4">
                <div class="card shadow">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">Fila de Espera - Dr(a). <?php echo htmlspecialchars($nome_medico); ?></h6>
                    </div>
                    <div class="card-body">
                        <ul class="list-group" id="fila-medico-<?php echo $fila[0]['id_fila']; ?>" data-id-medico="<?php echo $fila[0]['id_medico']; ?>">
                            <?php foreach ($fila as $paciente): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center" data-id-fila="<?php echo $paciente['id_fila']; ?>">
                                    <span>
                                        <i class="bi bi-grip-vertical me-2" style="cursor: move;"></i>
                                        <?php echo htmlspecialchars($paciente['nome_paciente']); ?>
                                    </span>
                                    <?php if ($paciente['ordem_prioridade'] >= 3): ?>
                                        <span class="badge bg-warning text-dark">Prioritário</span>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const statusDiv = document.getElementById('status-salvamento');

    // Encontra todas as listas de fila na página
    const listasDeFilas = document.querySelectorAll('.list-group');

    listasDeFilas.forEach(lista => {
        new Sortable(lista, {
            animation: 150,
            ghostClass: 'bg-light',
            handle: '.bi-grip-vertical', // Define o ícone como a "alça" para arrastar
            onEnd: function (evt) {
                // Pega todos os itens da lista na nova ordem
                const items = evt.to.children;
                const novaOrdemIds = Array.from(items).map(item => item.getAttribute('data-id-fila'));
                
                statusDiv.textContent = 'Salvando nova ordem...';
                statusDiv.className = 'alert alert-info';
                statusDiv.style.display = 'block';

                // Envia a nova ordem para a API
                fetch('../api/reordenar_fila.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ nova_ordem: novaOrdemIds })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        statusDiv.textContent = 'Ordem da fila salva com sucesso!';
                        statusDiv.className = 'alert alert-success';
                        
                        // Emite um evento para atualizar a lista do médico
                        const evento = new CustomEvent('filaReordenada', {
                            detail: { novaOrdem: novaOrdemIds }
                        });
                        window.dispatchEvent(evento);
                    } else {
                        statusDiv.textContent = 'Erro ao salvar a ordem da fila.';
                        statusDiv.className = 'alert alert-danger';
                    }
                    setTimeout(() => { statusDiv.style.display = 'none'; }, 3000);
                });
            }
        });
    });
});
</script>

<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>