<?php
$titulo_pagina = "Alocação Diária de Consultórios";
include_once './_template/header.php';
require_once '../conexao.php';

// Pega a data de hoje ou a data selecionada no formulário
$data_selecionada = $_GET['data'] ?? date('Y-m-d');

// Busca todos os médicos ativos
$medicos = $conexao->query("SELECT id, nome_completo FROM medicos WHERE ativo = 1 ORDER BY nome_completo")->fetch_all(MYSQLI_ASSOC);

// Busca todos os consultórios
$consultorios = $conexao->query("SELECT id, numero_sala FROM consultorios ORDER BY numero_sala")->fetch_all(MYSQLI_ASSOC);

// Busca as alocações já existentes para a data selecionada
$alocacoes_existentes = [];
$sql_alocacoes = "SELECT id_medico, id_consultorio FROM alocacao_consultorios_dia WHERE data_alocacao = ?";
$stmt = $conexao->prepare($sql_alocacoes);
$stmt->bind_param("s", $data_selecionada);
$stmt->execute();
$resultado = $stmt->get_result();
while ($row = $resultado->fetch_assoc()) {
    $alocacoes_existentes[$row['id_medico']] = $row['id_consultorio'];
}
$stmt->close();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Alocação de Consultórios</h1>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <form method="GET" action="alocacao_consultorios.php" class="d-flex align-items-center">
            <label for="data" class="form-label me-2 mb-0">Selecione a Data:</label>
            <input type="date" id="data" name="data" value="<?php echo $data_selecionada; ?>" class="form-control" style="width: 200px;">
            <button type="submit" class="btn btn-primary ms-2">Buscar</button>
        </form>
    </div>
    <div class="card-body">
        <form action="alocacao_acao.php" method="POST">
            <input type="hidden" name="data_alocacao" value="<?php echo $data_selecionada; ?>">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%">
                    <thead>
                        <tr>
                            <th>Médico</th>
                            <th>Consultório Alocado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($medicos as $medico): ?>
                            <tr>
                                <td class="align-middle"><?php echo htmlspecialchars($medico['nome_completo']); ?></td>
                                <td>
                                    <input type="hidden" name="alocacoes[<?php echo $medico['id']; ?>][id_medico]" value="<?php echo $medico['id']; ?>">
                                    <select name="alocacoes[<?php echo $medico['id']; ?>][id_consultorio]" class="form-select">
                                        <option value="">-- Nenhum --</option>
                                        <?php foreach ($consultorios as $consultorio): ?>
                                            <option value="<?php echo $consultorio['id']; ?>" <?php echo (isset($alocacoes_existentes[$medico['id']]) && $alocacoes_existentes[$medico['id']] == $consultorio['id']) ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($consultorio['numero_sala']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-end mt-3">
                <button type="submit" class="btn btn-primary">Salvar Alocações do Dia</button>
            </div>
        </form>
    </div>
</div>

<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>