<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit();
}
require_once '../conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data_alocacao = $_POST['data_alocacao'];
    $alocacoes = $_POST['alocacoes'];

    // Usaremos uma query que insere ou atualiza o registro se ele já existir (INSERT ... ON DUPLICATE KEY UPDATE)
    // Isso é possível por causa da chave única (UNIQUE KEY) que criamos na tabela para (id_medico, data_alocacao)
    $sql = "INSERT INTO alocacao_consultorios_dia (id_medico, id_consultorio, data_alocacao) 
            VALUES (?, ?, ?)
            ON DUPLICATE KEY UPDATE id_consultorio = VALUES(id_consultorio)";
    
    $stmt = $conexao->prepare($sql);

    // Deletar alocação se o admin selecionou "Nenhum"
    $sql_delete = "DELETE FROM alocacao_consultorios_dia WHERE id_medico = ? AND data_alocacao = ?";
    $stmt_delete = $conexao->prepare($sql_delete);

    $conexao->begin_transaction();
    try {
        foreach ($alocacoes as $aloc) {
            $id_medico = $aloc['id_medico'];
            $id_consultorio = $aloc['id_consultorio'];

            if (!empty($id_consultorio)) {
                // Se um consultório foi selecionado, insere ou atualiza
                $stmt->bind_param("iis", $id_medico, $id_consultorio, $data_alocacao);
                $stmt->execute();
            } else {
                // Se "Nenhum" foi selecionado, apaga a alocação existente para aquele médico naquele dia
                $stmt_delete->bind_param("is", $id_medico, $data_alocacao);
                $stmt_delete->execute();
            }
        }
        $conexao->commit();
        $_SESSION['success_message'] = "Alocações para o dia " . date("d/m/Y", strtotime($data_alocacao)) . " salvas com sucesso!";
    } catch (Exception $e) {
        $conexao->rollback();
        // Tratar erro aqui, se necessário
    }
    
    $stmt->close();
    $stmt_delete->close();
    $conexao->close();

    // Redireciona de volta para a página de alocação, mantendo a data selecionada
    header("Location: alocacao_consultorios.php?data=" . $data_alocacao);
    exit();
}
?>