<?php
$titulo_pagina = "Agenda da Clínica";
include_once './_template/header.php';
require_once '../conexao.php';
$medicos = $conexao->query("SELECT id, nome_completo FROM medicos WHERE ativo = 1 ORDER BY nome_completo")->fetch_all(MYSQLI_ASSOC);
$pacientes = $conexao->query("SELECT id, nome_completo, cpf FROM pacientes ORDER BY nome_completo")->fetch_all(MYSQLI_ASSOC);
$especialidades = $conexao->query("SELECT id, nome FROM especialidades ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
$filtro_medico_id = $_GET['medico_id'] ?? 'todos';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CliniSys - Agenda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    <style>
        @import url('https://fonts.googleapis.com/css?family=Roboto:400,500,700&display=swap');
        body, #agenda-container, .form-select, .btn, .fc, .modal-content, .modal-title, .modal-detalhes-nome, .modal-detalhes-label, .modal-detalhes-valor, .modal-detalhes-status-badge, .modal-detalhes-footer, .modal-detalhes-info, .modal-detalhes-telefone, .modal-detalhes-whatsapp, .modal-detalhes-acoes, .modal-detalhes-avatar, .fc-event, .fc-event-main, .fc-event-title, .fc-event-status {
            font-family: 'Roboto', sans-serif !important;
        }
        #agenda-container, .form-select, .btn, .fc { 
            font-family: 'Roboto', sans-serif !important; 
        }
        #calendario { 
            height: 80vh; 
        }
        .fc .fc-toolbar-title {
            font-family: 'Roboto', sans-serif !important;
            font-size: 1.5rem;
            font-weight: 700;
            color: #222;
        }
        .fc .fc-col-header-cell-cushion {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            padding: 8px 0 0 8px;
            font-family: 'Roboto', sans-serif !important;
            background: transparent;
        }
        .fc .fc-custom-day-header {
            font-size: 0.8em !important;
            color: #666 !important;
            font-weight: 400 !important;
            margin-bottom: 2px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-custom-day-date-row {
            display: flex;
            flex-direction: row;
            align-items: baseline;
            gap: 2px;
        }
        .fc .fc-custom-day-number {
            font-size: 2.1em;
            font-weight: 400 !important;
            color: #222;
            line-height: 1;
            display: inline-block;
            text-decoration: none !important;
        }
        .fc .fc-custom-day-month {
            font-size: 0.85em !important;
            color: #bbb !important;
            font-weight: 300 !important;
            margin-left: 2px !important;
            vertical-align: middle !important;
            letter-spacing: 0.5px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-daygrid-day-number, .fc .fc-timegrid-axis-cushion {
            font-family: 'Roboto', sans-serif !important;
            font-size: 1.2rem;
            font-weight: 400;
            color: #222;
            padding: 0 0 0 8px;
        }
        .fc .fc-daygrid-day-top {
            flex-direction: column;
            align-items: flex-start;
            padding-left: 8px;
            padding-top: 8px;
        }
        .fc .fc-daygrid-day {
            background: #fff;
            border-radius: 8px;
            margin: 2px;
        }
        .fc .fc-scrollgrid-section-header > th {
            background: #f8f9fa;
            border: none;
        }
        .fc .fc-scrollgrid-section-body > td {
            background: #fff;
            border: none;
        }
        .fc .fc-timegrid-slot-label {
            font-family: 'Roboto', sans-serif !important;
            font-size: 1rem;
            font-weight: 400;
            color: #888;
            padding-left: 8px;
        }
        .fc .fc-timegrid-slot {
            border-color: #f0f0f0;
        }
        .fc .fc-timegrid-axis-cushion {
            color: #888;
            font-size: 1rem;
            font-weight: 400;
        }
        .fc .fc-day-today {
            background: #e3f2fd !important;
        }
        .fc .fc-daygrid-day.fc-day-today {
            background: #e3f2fd !important;
        }
        .fc .fc-daygrid-day-number {
            color: #222;
            font-weight: 700;
        }
        .fc .fc-daygrid-day.fc-day-past {
            opacity: 0.7;
        }
        .fc .fc-scrollgrid, .fc .fc-scrollgrid-section {
            border: none !important;
        }
        .fc .fc-col-header-cell .fc-custom-day-number,
        .fc .fc-col-header-cell .fc-custom-day-number *,
        .fc .fc-col-header-cell-cushion .fc-custom-day-number,
        .fc .fc-col-header-cell-cushion .fc-custom-day-number *,
        .fc .fc-col-header-cell a .fc-custom-day-number,
        .fc .fc-col-header-cell a .fc-custom-day-number * {
            font-family: 'Roboto', sans-serif !important;
            font-weight: 300 !important;
            font-variation-settings: 'wght' 300 !important;
            color: #222 !important;
            text-decoration: none !important;
            background: none !important;
            line-height: 1 !important;
            display: inline-block !important;
            font-size: 1.5em !important;
        }
        .fc .fc-custom-day-number, .fc .fc-custom-day-number a {
            font-size: 2.1em !important;
            font-weight: 400 !important;
            color: #222 !important;
            line-height: 1 !important;
            display: inline-block !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-custom-day-month, .fc .fc-custom-day-month a {
            font-size: 0.85em !important;
            color: #bbb !important;
            font-weight: 300 !important;
            margin-left: 2px !important;
            vertical-align: middle !important;
            letter-spacing: 0.5px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-custom-day-header, .fc .fc-custom-day-header a {
            font-size: 0.8em !important;
            color: #666 !important;
            font-weight: 400 !important;
            margin-bottom: 2px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc-event, .fc-event-main {
            font-size: 12px !important;
        }
        /* Cores baseadas no status */
        .fc-event.status-agendado {
            background-color: #5bb4ee !important;
            color: #fff !important;
        }
        .fc-event.status-confirmado {
            background-color: #28a745 !important;
            color: #fff !important;
        }
        .fc-event.status-fila {
            background-color: #fd7e14 !important;
            color: #fff !important;
        }
        .fc-event.status-atendimento {
            background-color: #6f42c1 !important;
            color: #fff !important;
        }
        .fc-event.status-cancelado {
            background-color: #dc3545 !important;
            color: #fff !important;
        }
        .fc-event.status-nao_compareceu {
            background-color: #343a40 !important;
            color: #fff !important;
        }
        .modal-detalhes-topo {
            display: flex;
            align-items: center;
            padding: 16px;
            border-top-left-radius: 8px;
            border-top-right-radius: 8px;
            color: #fff;
            position: relative;
        }
        .modal-detalhes-avatar {
            width: 56px;
            height: 56px;
            border-radius: 50%;
            background: #e0e0e0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin-right: 16px;
            overflow: hidden;
        }
        .modal-detalhes-info {
            flex: 1;
        }
        .modal-detalhes-nome {
            font-size: 1.2rem;
            font-weight: 700;
            margin-bottom: 2px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .modal-detalhes-telefone {
            font-size: 1rem;
            margin-bottom: 2px;
        }
        .modal-detalhes-whatsapp-container {
            margin-top: 8px;
        }
        .modal-detalhes-whatsapp-link {
            display: flex;
            align-items: center;
            gap: 8px;
            color: #fff !important;
            text-decoration: none !important;
            background: #25d366;
            padding: 8px 12px;
            border-radius: 6px;
            font-size: 0.9rem;
            transition: background 0.2s;
            width: fit-content;
        }
        .modal-detalhes-whatsapp-link:hover {
            background: #1ebe57;
            color: #fff !important;
        }
        .modal-detalhes-whatsapp-link i.fab {
            font-size: 1.1rem;
        }
        .modal-detalhes-whatsapp-link i.fas {
            font-size: 0.8rem;
        }
        .modal-detalhes-acoes {
            position: absolute;
            top: 12px;
            right: 16px;
            display: flex;
            gap: 8px;
        }
        .modal-detalhes-body {
            padding: 20px 24px 8px 24px;
        }
        .modal-detalhes-label {
            font-size: 0.95rem;
            color: #888;
            margin-bottom: 2px;
        }
        .modal-detalhes-valor {
            font-size: 1.1rem;
            font-weight: 500;
            margin-bottom: 10px;
        }
        .modal-detalhes-status {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 10px;
        }
        .modal-detalhes-status-badge {
            padding: 2px 10px;
            border-radius: 12px;
            font-size: 0.95rem;
            color: #fff;
            font-weight: 600;
            background: #5bb4ee;
        }
        .modal-detalhes-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 24px 20px 24px;
            border-bottom-left-radius: 8px;
            border-bottom-right-radius: 8px;
            background: #f8f9fa;
        }
        .modal-novo-topo {
            display: flex;
            align-items: center;
            padding: 16px;
            border-top-left-radius: 8px;
            border-top-right-radius: 8px;
            color: #fff;
            background: #5bb4ee;
            position: relative;
        }
        .modal-novo-avatar {
            width: 56px;
            height: 56px;
            border-radius: 50%;
            background: #e0e0e0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin-right: 16px;
            overflow: hidden;
        }
        .modal-novo-info {
            flex: 1;
        }
        .modal-novo-nome {
            font-size: 1.2rem;
            font-weight: 700;
            margin-bottom: 2px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .modal-novo-telefone {
            font-size: 1rem;
            margin-bottom: 2px;
        }
        .modal-novo-whatsapp {
            color: #fff;
            background: #25d366;
            border: none;
            border-radius: 50%;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.3rem;
            margin-left: 8px;
            transition: background 0.2s;
        }
        .modal-novo-whatsapp:hover {
            background: #1ebe57;
        }
        .modal-novo-acoes {
            position: absolute;
            top: 12px;
            right: 16px;
            display: flex;
            gap: 8px;
        }
        /* Botão de adicionar no espaço em branco da agenda */
        .add-appointment-btn {
            position: absolute;
            top: 90px;
            left: 20px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #28a745;
            color: white;
            border: none;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.2s ease;
            box-shadow: 0 2px 6px rgba(40, 167, 69, 0.3);
            z-index: 10;
        }
        .add-appointment-btn:hover {
            background: #218838;
            transform: scale(1.05);
            box-shadow: 0 4px 10px rgba(40, 167, 69, 0.4);
        }
        /* Container do calendário com posição relativa */
        .card-body {
            position: relative;
        }
        /* Legenda discreta abaixo da agenda */
        .status-legend {
            display: flex;
            flex-wrap: wrap;
            gap: 12px;
            align-items: center;
            justify-content: center;
            margin-top: 15px;
            padding: 10px;
            font-size: 0.85rem;
        }
        .status-legend-item {
            display: flex;
            align-items: center;
            gap: 6px;
            color: #666;
        }
        .status-legend-color {
            width: 12px;
            height: 12px;
            border-radius: 2px;
        }
    </style>
</head>
<body>
    <div id="agenda-container">
        <div class="card shadow mb-4">
            <div class="card-body">
                <form id="filter-form" action="agenda_geral.php" method="GET" class="d-flex align-items-center">
                    <label for="medico_filtro" class="me-2 fw-bold">Médico:</label>
                    <select name="medico_id" id="medico_filtro" class="form-select" style="width: 250px;" onchange="this.form.submit()">
                        <option value="todos">Todos os médicos</option>
                        <?php foreach ($medicos as $medico): ?>
                            <option value="<?php echo $medico['id']; ?>" <?php echo ($filtro_medico_id == $medico['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($medico['nome_completo']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>
            </div>
        </div>
        <div class="card shadow">
            <div class="card-body">
                <div id="calendario"></div>
                <!-- Botão no espaço em branco da agenda -->
                <button class="add-appointment-btn" id="btnAddAppointment" title="Novo Agendamento" data-bs-toggle="modal" data-bs-target="#modalNovoAgendamento">
                    <i class="fas fa-plus"></i>
                </button>
            </div>
        </div>
        
        <!-- Legenda discreta abaixo da agenda -->
        <?php if ($filtro_medico_id === 'todos'): ?>
        <div class="status-legend">
            <div class="status-legend-item">
                <div class="status-legend-color" style="background-color: #5bb4ee;"></div>
                <span>Agendado</span>
            </div>
            <div class="status-legend-item">
                <div class="status-legend-color" style="background-color: #28a745;"></div>
                <span>Confirmado</span>
            </div>
            <div class="status-legend-item">
                <div class="status-legend-color" style="background-color: #fd7e14;"></div>
                <span>Em Fila</span>
            </div>
            <div class="status-legend-item">
                <div class="status-legend-color" style="background-color: #6f42c1;"></div>
                <span>Em Atendimento</span>
            </div>
            <div class="status-legend-item">
                <div class="status-legend-color" style="background-color: #dc3545;"></div>
                <span>Cancelado</span>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <div class="modal fade" id="modalDetalhes" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div id="modalDetalhesTopo" class="modal-detalhes-topo" style="background: #5bb4ee;">
                    <div class="modal-detalhes-avatar" id="detalheAvatarPaciente">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="modal-detalhes-info">
                        <div class="modal-detalhes-nome" id="detalhePacienteNome">Paciente</div>
                        <div class="modal-detalhes-telefone" id="detalhePacienteTelefone">Telefone</div>
                        <div class="modal-detalhes-whatsapp-container">
                            <a href="#" target="_blank" id="detalheWhatsapp" class="modal-detalhes-whatsapp-link" title="Confirmar por WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                                <span>Confirmar por WhatsApp Web</span>
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                    </div>
                    <div class="modal-detalhes-acoes">
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                </div>
                <div class="modal-detalhes-body">
                    <div class="modal-detalhes-label">Médico</div>
                    <div class="modal-detalhes-valor" id="detalheMedico">Dr(a). Nome Médico</div>
                    <div class="modal-detalhes-label">Horário</div>
                    <div class="modal-detalhes-valor" id="detalheHorario">Horário</div>
                    <div class="modal-detalhes-status">
                        <span class="modal-detalhes-label">Status:</span>
                        <span class="modal-detalhes-status-badge" id="detalheStatusBadge">Agendado</span>
                        <select id="statusAgendamento" class="form-select form-select-sm" style="width: auto; display: inline-block; margin-left: 8px;">
                            <option value="agendado">Agendado</option>
                            <option value="confirmado">Confirmado</option>
                            <option value="fila">Em Fila de Espera</option>
                            <option value="atendimento">Em Atendimento</option>
                            <option value="cancelado">Cancelado</option>
                        </select>
                    </div>
                </div>
                <div class="modal-detalhes-footer">
                    <button type="button" id="btnExcluir" class="btn btn-danger">Cancelar Agendamento</button>
                    <div class="d-flex gap-2">
                        <button type="button" id="btnEditarAgendamento" class="btn btn-primary">
                            <i class="fas fa-edit me-1"></i>
                            Editar
                        </button>
                        <button type="button" id="btnSalvarStatus" class="btn btn-success">Salvar Status</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNovoAgendamento" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-novo-topo justify-content-center" style="justify-content: center;">
                    <span style="font-size: 1.3rem; font-weight: 700; letter-spacing: 1px;">Agendamento</span>
                    <div class="modal-novo-acoes" style="right: 16px; position: absolute;">
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                </div>
                <form id="formNovoAgendamento">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label for="pacienteId" class="form-label">Paciente</label>
                                <select id="pacienteId" name="pacienteId" class="form-control" style="width: 100%;" required></select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="medicoId" class="form-label">Médico</label>
                                <select id="medicoId" name="medicoId" class="form-select" required>
                                    <option value="">Selecione...</option>
                                    <?php foreach ($medicos as $m): ?>
                                        <option value='<?php echo $m['id']; ?>'><?php echo htmlspecialchars($m['nome_completo']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="especialidadeId" class="form-label">Especialidade</label>
                                <select id="especialidadeId" name="especialidadeId" class="form-select" required>
                                    <?php foreach ($especialidades as $e): ?>
                                        <option value='<?php echo $e['id']; ?>'><?php echo htmlspecialchars($e['nome']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="data" class="form-label">Data</label>
                                <input type="date" id="data" name="data" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="horario_disponivel" class="form-label">Horários Disponíveis</label>
                                <select id="horario_disponivel" name="horario_disponivel" class="form-select" required>
                                    <option value="">Selecione primeiro a Data e o Médico</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/locales/pt-br.global.min.js'></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            const calendarioEl = document.getElementById('calendario');
            const modalDetalhes = new bootstrap.Modal(document.getElementById('modalDetalhes'));
            const modalNovoAgendamento = new bootstrap.Modal(document.getElementById('modalNovoAgendamento'));
            let eventoClicado = null;

            // Inicializa a busca de pacientes com Select2
            $('#pacienteId').select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#modalNovoAgendamento'),
                placeholder: 'Digite nome, CPF ou celular...',
                language: {
                    inputTooShort: function() {
                        return 'Digite pelo menos 2 caracteres';
                    },
                    noResults: function() {
                        return 'Nenhum resultado encontrado';
                    },
                    searching: function() {
                        return 'Buscando...';
                    },
                    loadingMore: function() {
                        return 'Carregando mais resultados...';
                    },
                    errorLoading: function() {
                        return 'Erro ao carregar resultados';
                    }
                },
                ajax: {
                    url: '../api/get_pacientes_simplificado.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return { results: data.results };
                    },
                    cache: true
                }
            });

            // Elementos do formulário do modal
            const medicoSelectModal = document.getElementById('medicoId');
            const dataInputModal = document.getElementById('data');
            const horariosSelectModal = document.getElementById('horario_disponivel');

            // Função para buscar horários disponíveis
            function buscarHorarios() {
                return new Promise((resolve, reject) => {
                    const medicoId = medicoSelectModal.value;
                    const data = dataInputModal.value;

                    if (medicoId && data) {
                        horariosSelectModal.disabled = true;
                        horariosSelectModal.innerHTML = '<option>Buscando...</option>';

                        fetch(`../api/get_slots_disponiveis.php?medico_id=${medicoId}&data=${data}`)
                            .then(response => {
                                if (!response.ok) {
                                    throw new Error('Erro ao buscar horários');
                                }
                                return response.json();
                            })
                            .then(slots => {
                                horariosSelectModal.innerHTML = '<option value="">Selecione um horário</option>';
                                if (slots.length > 0) {
                                    slots.forEach(slot => {
                                        horariosSelectModal.add(new Option(slot, slot));
                                    });
                                } else {
                                    horariosSelectModal.innerHTML = '<option value="">Nenhum horário livre</option>';
                                }
                                resolve();
                            })
                            .catch(error => {
                                console.error('Erro:', error);
                                horariosSelectModal.innerHTML = '<option value="">Erro ao carregar horários</option>';
                                reject(error);
                            })
                            .finally(() => {
                                horariosSelectModal.disabled = false;
                            });
                    } else {
                        resolve();
                    }
                });
            }

            // Adiciona "escutadores" para buscar os horários quando o médico ou a data mudam
            medicoSelectModal.addEventListener('change', buscarHorarios);
            dataInputModal.addEventListener('change', buscarHorarios);

            const calendar = new FullCalendar.Calendar(calendarioEl, {
                locale: 'pt-br',
                initialView: 'timeGridWeek',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                buttonText: {
                    today: 'Hoje',
                    month: 'Mês',
                    week: 'Semana',
                    day: 'Dia'
                },
                firstDay: 1,
                allDaySlot: false,
                nowIndicator: true,
                scrollTime: new Date().toTimeString().substring(0, 5),
                slotDuration: '00:15:00',
                slotLabelInterval: '01:00:00',
                slotLabelFormat: {
                    hour: '2-digit',
                    minute: '2-digit',
                    hour12: false,
                    omitZeroMinute: false
                },
                dayHeaderContent: function(arg) {
                    const diaSemana = arg.date.toLocaleDateString('pt-BR', { weekday: 'short' });
                    const dia = arg.date.getDate().toString().padStart(2, '0');
                    const mes = (arg.date.getMonth() + 1).toString().padStart(2, '0');
                    return {
                        html: `<span class='fc-custom-day-header'>${diaSemana.charAt(0).toUpperCase() + diaSemana.slice(1)}.</span>
                               <span class='fc-custom-day-date-row'>
                                   <span class='fc-custom-day-number'>${dia}</span>
                                   <span class='fc-custom-day-month'>/${mes}</span>
                               </span>`
                    };
                },
                events: {
                    url: '../api/get_todos_agendamentos.php',
                    extraParams: function() {
                        return {
                            medico_id: document.getElementById('medico_filtro').value
                        };
                    }
                },
                eventClassNames: function(arg) {
                    const status = arg.event.extendedProps.status || 'agendado';
                    return ['status-' + status];
                },
                editable: true,
                eventClick: function(info) {
                    eventoClicado = info.event;
                    $('#detalhePacienteNome').text(info.event.title.split('\n')[0]);
                    
                    // Formatar e exibir telefone
                    const telefone = info.event.extendedProps.telefone || '';
                    if (telefone && telefone.trim() !== '') {
                        // Formatar telefone para exibição (ex: 22 99808 8466)
                        const apenasNumeros = telefone.replace(/\D/g, '');
                        let telefoneFormatado = '';
                        
                        if (apenasNumeros.length === 11) {
                            // Celular: 22 99999-9999
                            telefoneFormatado = apenasNumeros.replace(/(\d{2})(\d{5})(\d{4})/, '$1 $2-$3');
                        } else if (apenasNumeros.length === 10) {
                            // Fixo: 22 9999-9999
                            telefoneFormatado = apenasNumeros.replace(/(\d{2})(\d{4})(\d{4})/, '$1 $2-$3');
                        } else {
                            telefoneFormatado = telefone;
                        }
                        
                        $('#detalhePacienteTelefone').text(telefoneFormatado);
                        
                        // Configurar link do WhatsApp (adicionar 55 apenas para o WhatsApp)
                        const telefoneWhats = '55' + apenasNumeros;
                        $('#detalheWhatsapp').attr('href', 'https://wa.me/' + telefoneWhats);
                        $('.modal-detalhes-whatsapp-container').show();
                    } else {
                        $('#detalhePacienteTelefone').text('Telefone não informado');
                        $('.modal-detalhes-whatsapp-container').hide();
                    }
                    
                    $('#detalheAvatarPaciente').html('<i class="fas fa-user"></i>');
                    $('#detalheMedico').text(info.event.extendedProps.nome_medico);
                    $('#detalheHorario').text(info.event.start.toLocaleString('pt-BR', {dateStyle: 'short', timeStyle: 'short'}));
                    setTimeout(function() {
                        $('#statusAgendamento').val(info.event.extendedProps.status).trigger('change');
                    }, 100);
                    atualizarCorTopoModal(info.event.extendedProps.status);
                    modalDetalhes.show();
                },
                eventDrop: function(info) {
                    if (!confirm("Tem certeza que deseja reagendar esta consulta?")) {
                        info.revert();
                    } else {
                        fetch('../api/atualizar_agendamento.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({
                                id: info.event.id,
                                start: formatDateTime(info.event.start)
                            })
                        })
                        .then(r => r.json())
                        .then(res => {
                            if (!res.success) {
                                alert(res.message);
                                info.revert();
                            }
                        });
                    }
                },
                dateClick: function(info) {
                    $('#formNovoAgendamento').trigger("reset");
                    $('#pacienteId').val(null).trigger('change');
                    
                    // Preencher data
                    const data = info.dateStr.substring(0, 10);
                    $('#data').val(data);
                    
                    // Resetar título do modal
                    $('.modal-novo-topo span').text('Agendamento');
                    
                    // Limpar horários disponíveis
                    $('#horario_disponivel').html('<option value="">Selecione primeiro a Data e o Médico</option>');
                    
                    modalNovoAgendamento.show();
                },
                eventContent: function(arg) {
                    const status = arg.event.extendedProps.status || 'agendado';
                    const statusLabel = {
                        'agendado': 'Agendado',
                        'confirmado': 'Confirmado',
                        'fila': 'Em Fila de Espera',
                        'atendimento': 'Em Atendimento',
                        'cancelado': 'Cancelado',
                        'nao_compareceu': 'Não Compareceu'
                    }[status] || 'Agendado';
                    return {
                        html: `<div class=\"fc-event-main-frame\">
                            <div class=\"fc-event-title-container\">
                                <div class=\"fc-event-title fc-sticky\">${arg.event.title}</div>
                                <div class=\"fc-event-status\">${statusLabel}</div>
                            </div>
                        </div>`
                    };
                }
            });
            calendar.render();

            // Recarrega os eventos quando o filtro de médico for alterado
            document.getElementById('medico_filtro').addEventListener('change', function() {
                calendar.refetchEvents();
                
                // Controla a visibilidade da legenda de status
                const medicoId = this.value;
                const statusLegend = document.querySelector('.status-legend');
                if (statusLegend) {
                    if (medicoId === 'todos') {
                        statusLegend.style.display = 'flex';
                    } else {
                        statusLegend.style.display = 'none';
                    }
                }
            });

            // Ações dos Modais
            $('#btnExcluir').on('click', function() {
                if (eventoClicado && confirm("Atenção! Esta ação é permanente. Deseja cancelar este agendamento?")) {
                    fetch('../api/excluir_agendamento.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify({ id: eventoClicado.id })
                    })
                    .then(r => r.json())
                    .then(res => {
                        alert(res.message);
                        if (res.success) {
                            eventoClicado.remove();
                            modalDetalhes.hide();
                        }
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        alert('Erro ao excluir agendamento');
                    });
                }
            });

            // Adiciona evento para o botão de editar agendamento
            $('#btnEditarAgendamento').on('click', function() {
                if (eventoClicado) {
                    // Fechar modal de detalhes
                    modalDetalhes.hide();
                    
                    // Preencher o formulário de edição
                    $('#formNovoAgendamento').trigger("reset");
                    
                    // Definir que estamos editando
                    $('#formNovoAgendamento').data('editando', true);
                    $('#formNovoAgendamento').data('agendamento-id', eventoClicado.id);
                    
                    // Preencher os campos
                    const dataHora = new Date(eventoClicado.start);
                    const data = dataHora.toISOString().split('T')[0];
                    const hora = dataHora.toTimeString().substring(0, 5);
                    
                    $('#data').val(data);
                    
                    // Preencher médico (usar o ID do médico do evento)
                    const medicoId = eventoClicado.extendedProps.id_medico || eventoClicado.id_medico;
                    $('#medicoId').val(medicoId);
                    
                    // Buscar e preencher paciente usando Select2
                    if (eventoClicado.extendedProps.id_paciente) {
                        // Criar opção para o paciente atual
                        const nomePaciente = eventoClicado.title.split('\n')[0];
                        const option = new Option(nomePaciente, eventoClicado.extendedProps.id_paciente, true, true);
                        $('#pacienteId').append(option).trigger('change');
                    }
                    
                    // Preencher especialidade se disponível
                    if (eventoClicado.extendedProps.id_especialidade) {
                        $('#especialidadeId').val(eventoClicado.extendedProps.id_especialidade);
                    }
                    
                    // Buscar horários disponíveis e selecionar o atual
                    buscarHorarios().then(() => {
                        $('#horario_disponivel').val(hora);
                    });
                    
                    // Alterar título do modal
                    $('.modal-novo-topo span').text('Editar Agendamento');
                    
                    // Abrir modal de edição
                    modalNovoAgendamento.show();
                }
            });

            // Adiciona evento para o botão de salvar status
            $('#btnSalvarStatus').on('click', function() {
                if (eventoClicado) {
                    const novoStatus = $('#statusAgendamento').val();
                    const dados = {
                        id: eventoClicado.id,
                        status: novoStatus
                    };
                    fetch('../api/atualizar_agendamento.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify(dados)
                    })
                    .then(r => r.json())
                    .then(res => {
                        if (res.success) {
                            modalDetalhes.hide();
                            calendar.refetchEvents();
                        } else {
                            alert(res.message);
                            $('#statusAgendamento').val(eventoClicado.extendedProps.status);
                        }
                    })
                    .catch(error => {
                        alert('Erro ao atualizar status');
                        $('#statusAgendamento').val(eventoClicado.extendedProps.status);
                    });
                }
            });

            // Função para obter a cor baseada no status
            function getStatusColor(status) {
                const cores = {
                    'agendado': '#5bb4ee',
                    'confirmado': '#28a745',
                    'fila': '#fd7e14',
                    'atendimento': '#6f42c1',
                    'cancelado': '#dc3545'
                };
                return cores[status] || '#5bb4ee';
            }

            // Função para atualizar o topo do modal conforme status
            function atualizarCorTopoModal(status) {
                const cores = {
                    'agendado': '#5bb4ee',
                    'confirmado': '#28a745',
                    'fila': '#fd7e14',
                    'atendimento': '#6f42c1',
                    'cancelado': '#dc3545',
                    'nao_compareceu': '#343a40'
                };
                const statusLabel = {
                    'agendado': 'Agendado',
                    'confirmado': 'Confirmado',
                    'fila': 'Em Fila de Espera',
                    'atendimento': 'Em Atendimento',
                    'cancelado': 'Cancelado',
                    'nao_compareceu': 'Não Compareceu'
                }[status] || 'Agendado';
                $("#modalDetalhesTopo").css('background', cores[status] || '#5bb4ee');
                $("#detalheStatusBadge").text(statusLabel);
                $("#detalheStatusBadge").css('background', cores[status] || '#5bb4ee');
            }

            // Atualiza cor do topo ao mudar status
            $('#statusAgendamento').on('change', function() {
                atualizarCorTopoModal($(this).val());
            });

            // Lógica para salvar o formulário
            $('#formNovoAgendamento').on('submit', function(e) {
                e.preventDefault();
                const data = $('#data').val();
                const hora = $('#horario_disponivel').val();
                
                if (!hora) {
                    alert('Por favor, selecione um horário disponível.');
                    return;
                }

                const editando = $(this).data('editando');
                const agendamentoId = $(this).data('agendamento-id');

                const dados = {
                    pacienteId: $('#pacienteId').val(),
                    medicoId: $('#medicoId').val(),
                    especialidadeId: $('#especialidadeId').val(),
                    start: `${data}T${hora}`
                };

                // Se estiver editando, adicionar o ID
                if (editando && agendamentoId) {
                    dados.id = agendamentoId;
                }

                const url = editando ? '../api/atualizar_agendamento.php' : '../api/salvar_agendamento.php';

                fetch(url, {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify(dados)
                })
                .then(r => r.json())
                .then(res => {
                    alert(res.message);
                    if (res.success) {
                        modalNovoAgendamento.hide();
                        calendar.refetchEvents();
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    alert('Erro ao salvar agendamento');
                });
            });

            // Adicione a função utilitária para formatar a data/hora
            function formatDateTime(date) {
                return date.getFullYear() + '-' +
                    String(date.getMonth() + 1).padStart(2, '0') + '-' +
                    String(date.getDate()).padStart(2, '0') + ' ' +
                    String(date.getHours()).padStart(2, '0') + ':' +
                    String(date.getMinutes()).padStart(2, '0') + ':00';
            }

            // Preencher topo do modal novo agendamento ao abrir
            $('#modalNovoAgendamento').on('show.bs.modal', function() {
                // Topo azul para status Agendado
                $('.modal-novo-topo').css('background', '#5bb4ee');
                
                // Se não estiver editando, resetar título
                if (!$('#formNovoAgendamento').data('editando')) {
                    $('.modal-novo-topo span').text('Agendamento');
                }
            });

            // Resetar dados de edição ao fechar modal
            $('#modalNovoAgendamento').on('hidden.bs.modal', function() {
                $('#formNovoAgendamento').removeData('editando');
                $('#formNovoAgendamento').removeData('agendamento-id');
                $('.modal-novo-topo span').text('Agendamento');
            });
        });
    </script>
</body>
</html>