<?php
// Garante que a sessão seja iniciada apenas uma vez, da forma mais segura.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Proteção definitiva da página: se não houver 'admin_id' na sessão, redireciona para o login.
if (!isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit(); 
}

// Se chegou aqui, o usuário está logado.
$nome_admin = $_SESSION['admin_nome'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo_pagina ?? 'Painel Administrativo'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body { display: flex; min-height: 100vh; background-color: #f8f9fa; }
        .sidebar { min-width: 230px; max-width: 230px; background-color: #343a40; color: white; }
        .sidebar .nav-link { color: rgba(255, 255, 255, 0.7); padding: 10px 20px; border-radius: 0.25rem; margin-bottom: 0.25rem; transition: color .15s ease-in-out,background-color .15s ease-in-out; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { color: white; background-color: #495057; }
        .sidebar .nav-link .bi { margin-right: 10px; }
        .content { flex-grow: 1; padding: 0; display: flex; flex-direction: column; }
        .top-bar { background-color: #ffffff; padding: 1rem 0.25rem 1rem 1rem; box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075); display: flex; justify-content: space-between; align-items: center; }
        .main-content { padding: 1.5rem 0rem 1.5rem 1.5rem; flex-grow: 1; }
        .sidebar-brand-text { font-size: 1.2rem; font-weight: bold; }
    </style>
</head>
<body>
    <div class="sidebar p-3 d-flex flex-column">
        <div class="text-center mb-4">
            <a href="dashboard.php" class="text-white text-decoration-none sidebar-brand-text">CliniSys</a>
        </div>
    <ul class="nav flex-column flex-grow-1">
        <li class="nav-item">
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php"><i class="bi bi-grid-1x2-fill"></i> Dashboard</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'agenda_geral.php' ? 'active' : ''; ?>" href="agenda_geral.php"><i class="bi bi-calendar3"></i> Agenda</a>
        </li>
        <hr class="bg-secondary">
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'pacientes') !== false ? 'active' : ''; ?>" href="pacientes_listar.php">
                <i class="bi bi-people-fill"></i> Pacientes
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'checkin') !== false ? 'active' : ''; ?>" href="checkin.php">
                <i class="bi bi-person-check-fill"></i> Check-in
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'fila_gerenciar') !== false ? 'active' : ''; ?>" href="fila_gerenciar.php">
                <i class="bi bi-list-ol"></i> Gerenciar Fila
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'alocacao') !== false ? 'active' : ''; ?>" href="alocacao_consultorios.php">
                <i class="bi bi-calendar-week-fill"></i> Alocação Diária
            </a>
        </li>
        <hr class="bg-secondary">
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'medicos') !== false ? 'active' : ''; ?>" href="medicos_listar.php"><i class="bi bi-heart-pulse-fill"></i> Médicos</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'especialidades') !== false ? 'active' : ''; ?>" href="especialidades_listar.php"><i class="bi bi-bookmark-star-fill"></i> Especialidades</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'consultorios') !== false ? 'active' : ''; ?>" href="consultorios_listar.php"><i class="bi bi-door-open-fill"></i> Consultórios</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'horarios') !== false ? 'active' : ''; ?>" href="medicos_horarios.php"><i class="bi bi-clock-history"></i> Horários Médicos</a>
        </li>
    </ul>
    <div class="mt-auto">
        <a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right"></i> Sair</a>
    </div>
    </div>
    <div class="content">
        <div class="top-bar">
             <h1 class="h4 mb-0 text-gray-800"><?php echo $titulo_pagina ?? 'Painel'; ?></h1>
             <div class="dropdown">
                <a href="#" class="d-flex align-items-center text-dark text-decoration-none dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-person-circle fs-4 me-2"></i>
                    <strong><?php echo htmlspecialchars($nome_admin); ?></strong>
                </a>
                <ul class="dropdown-menu dropdown-menu-end text-small shadow">
                    <li><a class="dropdown-item" href="logout.php">Sair</a></li>
                </ul>
            </div>
        </div>
        <div class="main-content">