<?php
header('Content-Type: application/json');
require_once '../conexao.php';

$dados = json_decode(file_get_contents('php://input'), true);
$idAgendamento = $dados['agendamento_id'] ?? 0;
$ordemPrioridade = $dados['ordem_prioridade'] ?? 1; // Pega o valor do menu (padrão 1 = Normal)

if ($idAgendamento === 0) {
    echo json_encode(['success' => false, 'message' => 'ID do agendamento não fornecido.']);
    exit;
}

$data_hoje = date('Y-m-d');
$hora_agora = date('Y-m-d H:i:s');

// ... (código que busca agendamento e alocação continua igual) ...
$agendamento_sql = "SELECT id_medico FROM agendamentos WHERE id = ?";
$stmt_ag = $conexao->prepare($agendamento_sql);
$stmt_ag->bind_param("i", $idAgendamento);
$stmt_ag->execute();
$agendamento = $stmt_ag->get_result()->fetch_assoc();
$idMedico = $agendamento['id_medico'];

$alocacao_sql = "SELECT id_consultorio FROM alocacao_consultorios_dia WHERE id_medico = ? AND data_alocacao = ?";
$stmt_al = $conexao->prepare($alocacao_sql);
$stmt_al->bind_param("is", $idMedico, $data_hoje);
$stmt_al->execute();
$alocacao = $stmt_al->get_result()->fetch_assoc();
if (!$alocacao) {
    echo json_encode(['success' => false, 'message' => 'Erro: Este médico não tem um consultório alocado para hoje.']);
    exit;
}
$idConsultorio = $alocacao['id_consultorio'];


$conexao->begin_transaction();
try {
    $sql_update = "UPDATE agendamentos SET check_in_realizado = 1, hora_check_in = ? WHERE id = ?";
    $stmt_update = $conexao->prepare($sql_update);
    $stmt_update->bind_param("si", $hora_agora, $idAgendamento);
    $stmt_update->execute();

    // Query de inserção na fila, agora com o nível de prioridade vindo do menu
    $sql_fila = "INSERT INTO fila_espera (id_agendamento, id_medico, id_consultorio, hora_chegada, status_fila, ordem_prioridade) VALUES (?, ?, ?, ?, 'Aguardando', ?)";
    $stmt_fila = $conexao->prepare($sql_fila);
    $stmt_fila->bind_param("iiisi", $idAgendamento, $idMedico, $idConsultorio, $hora_agora, $ordemPrioridade);
    $stmt_fila->execute();

    $conexao->commit();
    echo json_encode(['success' => true, 'message' => 'Check-in realizado com sucesso!']);
} catch (Exception $e) {
    $conexao->rollback();
    if ($conexao->errno == 1062) {
        echo json_encode(['success' => false, 'message' => 'Este paciente já realizou o check-in.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao realizar o check-in: ' . $e->getMessage()]);
    }
}
$conexao->close();
?>