<?php
session_start();
header('Content-Type: application/json');

// Medida de segurança: Garante que apenas um médico logado pode ver a fila.
if (!isset($_SESSION['medico_id'])) {
    echo json_encode(['error' => 'Acesso não autorizado']);
    exit;
}

require_once '../conexao.php';

$idMedico = $_SESSION['medico_id'];

$sql = "SELECT 
            f.id as id_fila,
            p.nome_completo as nome_paciente,
            f.hora_chegada,
            f.status_fila
        FROM 
            fila_espera f
        JOIN 
            agendamentos a ON f.id_agendamento = a.id
        JOIN
            pacientes p ON a.id_paciente = p.id
        WHERE 
            f.id_medico = ? AND f.status_fila = 'Aguardando'
        ORDER BY 
            f.hora_chegada ASC";

$stmt = $conexao->prepare($sql);
$stmt->bind_param("i", $idMedico);
$stmt->execute();
$resultado = $stmt->get_result();
$fila = $resultado->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conexao->close();

echo json_encode($fila);
?>