<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agendamento de Consulta - CliniSys</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js'></script>
    <style>
        body { background-color: #f8f9fa; }
        .fc .fc-button-primary { background-color: #0d6efd; border-color: #0d6efd; }
        .fc-event{ cursor: pointer; }
    </style>
</head>
<body>
    <div class="container my-5">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h1 class="h3 mb-0">Agende sua Consulta</h1>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="especialidade" class="form-label">1. Escolha a Especialidade:</label>
                        <select id="especialidade" class="form-select">
                            <option selected disabled>-- Selecione --</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="medico" class="form-label">2. Escolha o Médico:</label>
                        <select id="medico" class="form-select" disabled>
                            <option selected disabled>-- Primeiro escolha uma especialidade --</option>
                        </select>
                    </div>
                </div>

                <hr class="my-4">

                <p class="text-center text-muted" id="instrucao_calendario">3. Selecione um horário disponível no calendário abaixo.</p>
                <div id="calendario" class="mt-4"></div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalAgendamento" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalAgendamentoLabel">Confirmar Agendamento</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Você está agendando uma consulta com:</p>
                    <p><strong>Médico:</strong> <span id="modalMedico"></span></p>
                    <p><strong>Data e Hora:</strong> <span id="modalDataHora"></span></p>
                    <hr>
                    <p>Por favor, preencha seus dados:</p>
                    <form id="formAgendamento">
                         <div class="mb-3">
                            <label for="nomePaciente" class="form-label">Nome Completo</label>
                            <input type="text" class="form-control" id="nomePaciente" required>
                        </div>
                         <div class="mb-3">
                            <label for="telefonePaciente" class="form-label">Telefone</label>
                            <input type="tel" class="form-control" id="telefonePaciente" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" id="btnConfirmar" class="btn btn-primary">Confirmar Agendamento</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Seletores dos elementos HTML
        const especialidadeSelect = document.getElementById('especialidade');
        const medicoSelect = document.getElementById('medico');
        const calendarioEl = document.getElementById('calendario');
        const instrucaoEl = document.getElementById('instrucao_calendario');
        const modalEl = new bootstrap.Modal(document.getElementById('modalAgendamento'));
        const modalMedicoEl = document.getElementById('modalMedico');
        const modalDataHoraEl = document.getElementById('modalDataHora');
        const btnConfirmar = document.getElementById('btnConfirmar');
        const nomePacienteInput = document.getElementById('nomePaciente');
        const telefonePacienteInput = document.getElementById('telefonePaciente');

        // Variável para guardar informações do evento clicado
        let eventoClicadoInfo = null;

        // Inicialização do FullCalendar
        let calendar = new FullCalendar.Calendar(calendarioEl, {
            locale: 'pt-br',
            initialView: 'timeGridWeek',
            slotMinTime: '08:00:00',
            slotMaxTime: '19:00:00',
            allDaySlot: false,
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,timeGridDay'
            },
            buttonText: { today: 'Hoje', month: 'Mês', week: 'Semana', day: 'Dia' },
            events: [],
            eventClick: function(info) {
                eventoClicadoInfo = info; // Guarda o evento clicado
                
                const medicoNome = medicoSelect.options[medicoSelect.selectedIndex].text;
                const dataHora = new Date(info.event.start);
                const dataFormatada = dataHora.toLocaleDateString('pt-BR') + ' às ' + dataHora.toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
                
                modalMedicoEl.textContent = medicoNome;
                modalDataHoraEl.textContent = dataFormatada;
                modalEl.show();
            }
        });
        calendar.render();

        // Carregar especialidades
        fetch('api/get_especialidades.php')
            .then(response => response.json())
            .then(data => {
                data.forEach(espec => {
                    especialidadeSelect.add(new Option(espec.nome, espec.id));
                });
            });

        // Evento ao mudar a especialidade
        especialidadeSelect.addEventListener('change', function() {
            const especialidadeId = this.value;
            medicoSelect.disabled = true;
            medicoSelect.innerHTML = '<option selected disabled>-- Carregando... --</option>';
            calendar.removeAllEvents();
            instrucaoEl.textContent = '2. Escolha o Médico:';
            if (especialidadeId) {
                fetch(`api/get_medicos.php?especialidade_id=${especialidadeId}`)
                    .then(response => response.json())
                    .then(data => {
                        medicoSelect.innerHTML = '<option selected disabled>-- Selecione --</option>';
                        if (data.length > 0) {
                            data.forEach(medico => medicoSelect.add(new Option(medico.nome_completo, medico.id)));
                            medicoSelect.disabled = false;
                        } else {
                            medicoSelect.innerHTML = '<option selected disabled>-- Nenhum médico --</option>';
                        }
                    });
            }
        });

        // Evento ao mudar o médico
        medicoSelect.addEventListener('change', function() {
            const medicoId = this.value;
            instrucaoEl.textContent = '3. Selecione um horário disponível.';
            if (medicoId) {
                calendar.removeAllEvents();
                calendar.addEventSource(`api/get_horarios.php?medico_id=${medicoId}`);
            }
        });

        // *** NOVA LÓGICA PARA CONFIRMAR O AGENDAMENTO ***
        btnConfirmar.addEventListener('click', function() {
            const agendamento = {
                nome: nomePacienteInput.value,
                telefone: telefonePacienteInput.value,
                medicoId: medicoSelect.value,
                especialidadeId: especialidadeSelect.value,
                start: eventoClicadoInfo.event.startStr // Pega a data/hora do evento que foi clicado
            };

            if (!agendamento.nome || !agendamento.telefone) {
                alert('Por favor, preencha seu nome e telefone.');
                return;
            }

            // Envia os dados para o servidor
            fetch('api/salvar_agendamento.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(agendamento),
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message); // Exibe a mensagem de sucesso ou erro do servidor
                if (data.success) {
                    modalEl.hide(); // Fecha o modal
                    eventoClicadoInfo.event.remove(); // Remove o horário do calendário
                    // Limpa os campos do formulário
                    nomePacienteInput.value = '';
                    telefonePacienteInput.value = '';
                }
            })
            .catch((error) => {
                console.error('Erro:', error);
                alert('Ocorreu um erro de comunicação. Tente novamente.');
            });
        });
    });
</script>
</body>
</html>