<?php 
// O header já é incluído pelas páginas 'adicionar' e 'editar'
include_once './_template/header.php'; 
?>

<h1 class="h3 mb-4 text-gray-800"><?php echo $titulo_pagina; ?></h1>
<form action="pacientes_acao.php" method="POST" id="formPaciente">
    <input type="hidden" name="acao" value="<?php echo $acao; ?>">
    <?php if (isset($id)): ?><input type="hidden" name="id" value="<?php echo htmlspecialchars($paciente['id']); ?>"><?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Dados Essenciais</h6></div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="nome_completo" class="form-label">Nome Completo</label>
                    <input type="text" class="form-control" id="nome_completo" name="nome_completo" value="<?php echo htmlspecialchars($paciente['nome_completo'] ?? ''); ?>" required>
                </div>
                <div class="col-md-3 mb-3">
                    <label for="data_nascimento" class="form-label">Data de Nascimento</label>
                    <input type="date" class="form-control" id="data_nascimento" name="data_nascimento" value="<?php echo htmlspecialchars($paciente['data_nascimento'] ?? ''); ?>" required>
                </div>
                <div class="col-md-3 mb-3">
                    <label for="sexo" class="form-label">Sexo</label>
                    <select id="sexo" name="sexo" class="form-select">
                        <option value="">Selecione</option>
                        <option value="Masculino" <?php echo (($paciente['sexo'] ?? '') == 'Masculino') ? 'selected' : ''; ?>>Masculino</option>
                        <option value="Feminino" <?php echo (($paciente['sexo'] ?? '') == 'Feminino') ? 'selected' : ''; ?>>Feminino</option>
                        <option value="Outro" <?php echo (($paciente['sexo'] ?? '') == 'Outro') ? 'selected' : ''; ?>>Outro</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="cpf" class="form-label">CPF</label>
                    <input type="text" class="form-control" id="cpf" name="cpf" placeholder="000.000.000-00" value="<?php echo htmlspecialchars($paciente['cpf'] ?? ''); ?>" required>
                    <div id="cpf-error" class="text-danger mt-1" style="display: none;">CPF inválido</div>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="telefone_contato" class="form-label">Whatsapp/Tel</label>
                    <input type="text" class="form-control" id="telefone_contato" name="telefone_contato" placeholder="(00) 00000-0000" value="<?php echo htmlspecialchars($paciente['telefone_contato'] ?? ''); ?>" required>
                </div>
            </div>
             <div class="row">
                <div class="col-md-3 mb-3">
                    <label for="cep" class="form-label">CEP</label>
                    <input type="text" class="form-control" id="cep" name="cep" value="<?php echo htmlspecialchars($paciente['cep'] ?? ''); ?>">
                </div>
                <div class="col-md-7 mb-3">
                    <label for="endereco" class="form-label">Endereço (Rua, Av.)</label>
                    <input type="text" class="form-control" id="endereco" name="endereco" value="<?php echo htmlspecialchars($paciente['endereco'] ?? ''); ?>">
                </div>
                 <div class="col-md-2 mb-3">
                    <label for="numero" class="form-label">Número</label>
                    <input type="text" class="form-control" id="numero" name="numero" value="">
                </div>
            </div>
             <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="bairro" class="form-label">Bairro</label>
                    <input type="text" class="form-control" id="bairro" name="bairro" value="<?php echo htmlspecialchars($paciente['bairro'] ?? ''); ?>">
                </div>
                 <div class="col-md-4 mb-3">
                    <label for="cidade" class="form-label">Cidade</label>
                    <input type="text" class="form-control" id="cidade" name="cidade" value="<?php echo htmlspecialchars($paciente['cidade'] ?? ''); ?>">
                </div>
                <div class="col-md-4 mb-3">
                    <label for="estado" class="form-label">Estado (UF)</label>
                    <input type="text" class="form-control" id="estado" name="estado" value="<?php echo htmlspecialchars($paciente['estado'] ?? ''); ?>">
                </div>
            </div>
        </div>
    </div>
    
    <div class="accordion" id="dadosComplementares">
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">Dados Pessoais Complementares</button>
            </h2>
            <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#dadosComplementares">
                <div class="accordion-body">
                    <div class="row">
                        <div class="col-md-4 mb-3"><label for="rg" class="form-label">RG</label><input type="text" class="form-control" id="rg" name="rg" value="<?php echo htmlspecialchars($paciente['rg'] ?? ''); ?>"></div>
                        <div class="col-md-4 mb-3"><label for="estado_civil" class="form-label">Estado Civil</label><input type="text" class="form-control" id="estado_civil" name="estado_civil" value="<?php echo htmlspecialchars($paciente['estado_civil'] ?? ''); ?>"></div>
                        <div class="col-md-4 mb-3"><label for="nacionalidade" class="form-label">Nacionalidade</label><input type="text" class="form-control" id="nacionalidade" name="nacionalidade" value="<?php echo htmlspecialchars($paciente['nacionalidade'] ?? ''); ?>"></div>
                        <div class="col-md-8 mb-3"><label for="nome_mae" class="form-label">Nome da Mãe</label><input type="text" class="form-control" id="nome_mae" name="nome_mae" value="<?php echo htmlspecialchars($paciente['nome_mae'] ?? ''); ?>"></div>
                         <div class="col-md-4 mb-3"><label for="telefone_alternativo" class="form-label">Telefone Alternativo</label><input type="text" class="form-control" id="telefone_alternativo" name="telefone_alternativo" value="<?php echo htmlspecialchars($paciente['telefone_alternativo'] ?? ''); ?>"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">Dados Clínicos</button>
            </h2>
            <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#dadosComplementares">
                <div class="accordion-body">
                     <div class="row">
                        <div class="col-md-4 mb-3"><label for="tipo_sanguineo" class="form-label">Tipo Sanguíneo</label><input type="text" class="form-control" id="tipo_sanguineo" name="tipo_sanguineo" value="<?php echo htmlspecialchars($paciente['tipo_sanguineo'] ?? ''); ?>"></div>
                        <div class="col-md-8 mb-3"><label for="medicacoes_continuas" class="form-label">Medicações Contínuas</label><input type="text" class="form-control" id="medicacoes_continuas" name="medicacoes_continuas" value="<?php echo htmlspecialchars($paciente['medicacoes_continuas'] ?? ''); ?>"></div>
                        <div class="mb-3"><label for="alergias" class="form-label">Alergias</label><textarea class="form-control" id="alergias" name="alergias" rows="2"><?php echo htmlspecialchars($paciente['alergias'] ?? ''); ?></textarea></div>
                        <div class="mb-3"><label for="doencas_cronicas" class="form-label">Doenças Crônicas</label><textarea class="form-control" id="doencas_cronicas" name="doencas_cronicas" rows="2"><?php echo htmlspecialchars($paciente['doencas_cronicas'] ?? ''); ?></textarea></div>
                        <div class="mb-3"><label for="historico_cirurgias" class="form-label">Histórico de Cirurgias</label><textarea class="form-control" id="historico_cirurgias" name="historico_cirurgias" rows="2"><?php echo htmlspecialchars($paciente['historico_cirurgias'] ?? ''); ?></textarea></div>
                    </div>
                </div>
            </div>
        </div>
        </div>

    <div class="d-flex justify-content-end mt-4">
        <a href="pacientes_listar.php" class="btn btn-secondary me-2">Cancelar</a>
        <button type="submit" class="btn btn-primary">Salvar Cadastro</button>
    </div>
</form>

<script>
// Lógica para busca de CEP
document.getElementById('cep').addEventListener('blur', function() {
    const cep = this.value.replace(/\D/g, '');
    if (cep.length === 8) {
        fetch(`https://viacep.com.br/ws/${cep}/json/`)
            .then(response => response.json())
            .then(data => {
                if (!data.erro) {
                    document.getElementById('endereco').value = data.logradouro;
                    document.getElementById('bairro').value = data.bairro;
                    document.getElementById('cidade').value = data.localidade;
                    document.getElementById('estado').value = data.uf;
                    document.getElementById('numero').focus();
                } else {
                    alert('CEP não encontrado.');
                }
            })
            .catch(error => console.error('Erro ao buscar CEP:', error));
    }
});

// Lógica para validar CPF
function validarCPF(cpf) {
    cpf = cpf.replace(/[^\d]+/g,'');
    if(cpf == '') return false;
    if (cpf.length != 11 || /^(\d)\1+$/.test(cpf)) return false;
    let soma = 0, resto;
    for (let i = 1; i <= 9; i++) soma = soma + parseInt(cpf.substring(i-1, i)) * (11 - i);
    resto = (soma * 10) % 11;
    if ((resto == 10) || (resto == 11)) resto = 0;
    if (resto != parseInt(cpf.substring(9, 10)) ) return false;
    soma = 0;
    for (let i = 1; i <= 10; i++) soma = soma + parseInt(cpf.substring(i-1, i)) * (12 - i);
    resto = (soma * 10) % 11;
    if ((resto == 10) || (resto == 11)) resto = 0;
    if (resto != parseInt(cpf.substring(10, 11) ) ) return false;
    return true;
}

const cpfInput = document.getElementById('cpf');
const cpfError = document.getElementById('cpf-error');
cpfInput.addEventListener('blur', function() {
    if (this.value && !validarCPF(this.value)) {
        cpfError.style.display = 'block';
    } else {
        cpfError.style.display = 'none';
    }
});

// Impede o envio do formulário se o CPF for inválido
document.getElementById('formPaciente').addEventListener('submit', function(e) {
    if (cpfInput.value && !validarCPF(cpfInput.value)) {
        e.preventDefault();
        alert('O CPF digitado é inválido. Por favor, corrija antes de salvar.');
        cpfInput.focus();
    }
});

// Scripts de máscara (usando uma biblioteca leve, IMask.js)
</script>
<script src="https://unpkg.com/imask"></script>
<script>
    IMask(document.getElementById('cpf'), { mask: '000.000.000-00' });
    IMask(document.getElementById('telefone_contato'), { mask: '(00) 00000-0000' });
    IMask(document.getElementById('telefone_alternativo'), { mask: '(00) 0000-0000' });
    IMask(document.getElementById('cep'), { mask: '00000-000' });
</script>

<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>