<?php
$titulo_pagina = "Gerenciar Médicos";
include_once './_template/header.php';
require_once '../conexao.php';

// SQL CORRIGIDO: Usamos LEFT JOIN para garantir que todos os médicos apareçam,
// mesmo que ainda não tenham especialidades vinculadas.
$sql = "SELECT 
            m.id, 
            m.nome_completo, 
            m.whatsapp, 
            m.email, 
            m.ativo, 
            GROUP_CONCAT(e.nome ORDER BY e.nome SEPARATOR ', ') as especialidades
        FROM 
            medicos m
        LEFT JOIN 
            medico_especialidades me ON m.id = me.id_medico
        LEFT JOIN 
            especialidades e ON me.id_especialidade = e.id
        GROUP BY 
            m.id
        ORDER BY 
            m.nome_completo";
            
$resultado = $conexao->query($sql);
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Médicos</h1>
    <a href="medicos_adicionar.php" class="btn btn-success"><i class="bi bi-plus-lg"></i> Adicionar Novo</a>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" width="100%">
                <thead>
                    <tr>
                        <th>Nome Completo</th>
                        <th>Contato (WhatsApp)</th>
                        <th>Especialidades</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resultado && $resultado->num_rows > 0): ?>
                        <?php while($medico = $resultado->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($medico['nome_completo']); ?></td>
                                <td><?php echo htmlspecialchars($medico['whatsapp']); ?></td>
                                <td><?php echo htmlspecialchars($medico['especialidades'] ?? 'Nenhuma especialidade definida'); ?></td>
                                <td class="text-center">
                                    <?php if ($medico['ativo']): ?>
                                        <span class="badge bg-success">Ativo</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <a href="medicos_acao.php?acao=toggle_status&id=<?php echo $medico['id']; ?>" class="btn btn-secondary btn-sm" title="<?php echo $medico['ativo'] ? 'Desativar' : 'Ativar'; ?>">
                                        <i class="bi <?php echo $medico['ativo'] ? 'bi-eye-slash-fill' : 'bi-eye-fill'; ?>"></i>
                                    </a>
                                    <a href="medicos_editar.php?id=<?php echo $medico['id']; ?>" class="btn btn-warning btn-sm" title="Editar"><i class="bi bi-pencil-fill"></i></a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="5" class="text-center">Nenhum médico cadastrado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php 
if ($resultado) $resultado->close();
$conexao->close();
include_once './_template/footer.php'; 
?>