<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit();
}
require_once '../conexao.php';

$acao = $_POST['acao'] ?? $_GET['acao'] ?? '';

switch ($acao) {
    case 'adicionar':
        if (empty($_POST['nome_completo']) || empty($_POST['whatsapp']) || empty($_POST['senha']) || empty($_POST['especialidades'])) {
            $_SESSION['error_message'] = "Erro: Nome, WhatsApp, Senha e ao menos uma Especialidade são obrigatórios.";
            header("Location: medicos_adicionar.php");
            exit();
        }

        $conexao->begin_transaction();
        try {
            $sql_medico = "INSERT INTO medicos (nome_completo, endereco, whatsapp, email, senha, duracao_consulta_min) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt_medico = $conexao->prepare($sql_medico);
            if ($stmt_medico === false) throw new Exception("Erro ao preparar query do médico: " . $conexao->error);

            $senha_hash = password_hash($_POST['senha'], PASSWORD_DEFAULT);
            $duracao = (int)($_POST['duracao_consulta_min'] ?? 30);
            $email = empty($_POST['email']) ? null : $_POST['email']; // Salva NULL se o email estiver vazio

            $stmt_medico->bind_param("sssssi", $_POST['nome_completo'], $_POST['endereco'], $_POST['whatsapp'], $email, $senha_hash, $duracao);
            
            if (!$stmt_medico->execute()) throw new Exception("Erro ao inserir médico: " . $stmt_medico->error);
            
            $id_medico = $conexao->insert_id;
            if ($id_medico === 0) throw new Exception("Não foi possível obter o ID do novo médico.");
            
            $stmt_medico->close();

            $sql_espec = "INSERT INTO medico_especialidades (id_medico, id_especialidade) VALUES (?, ?)";
            $stmt_espec = $conexao->prepare($sql_espec);
            if ($stmt_espec === false) throw new Exception("Erro ao preparar query das especialidades: " . $conexao->error);

            foreach ($_POST['especialidades'] as $id_especialidade) {
                $stmt_espec->bind_param("ii", $id_medico, $id_especialidade);
                if (!$stmt_espec->execute()) throw new Exception("Erro ao vincular especialidade: " . $stmt_espec->error);
            }
            $stmt_espec->close();
            
            $conexao->commit();
            $_SESSION['success_message'] = "Médico adicionado com sucesso!";

        } catch (Exception $e) {
            $conexao->rollback();
            $_SESSION['error_message'] = $e->getMessage();
        }
        break;

    case 'editar':
        $id = $_POST['id'];
        if (empty($_POST['nome_completo']) || empty($_POST['whatsapp']) || empty($_POST['especialidades'])) {
            $_SESSION['error_message'] = "Erro: Nome, WhatsApp e ao menos uma Especialidade são obrigatórios.";
            header("Location: medicos_editar.php?id=$id");
            exit();
        }

        $conexao->begin_transaction();
        try {
            // Atualiza dados do médico
            $sql = "UPDATE medicos SET nome_completo=?, endereco=?, whatsapp=?, email=?, duracao_consulta_min=?";
            $params = [$_POST['nome_completo'], $_POST['endereco'], $_POST['whatsapp'], empty($_POST['email']) ? null : $_POST['email'], (int)$_POST['duracao_consulta_min']];
            $types = "ssssi";

            // Atualiza senha se foi informada
            if (!empty($_POST['senha'])) {
                $sql .= ", senha=?";
                $params[] = password_hash($_POST['senha'], PASSWORD_DEFAULT);
                $types .= "s";
            }
            $sql .= " WHERE id=?";
            $params[] = $id;
            $types .= "i";

            $stmt = $conexao->prepare($sql);
            $stmt->bind_param($types, ...$params);
            if (!$stmt->execute()) throw new Exception("Erro ao atualizar médico: " . $stmt->error);
            $stmt->close();

            // Atualiza especialidades
            $conexao->query("DELETE FROM medico_especialidades WHERE id_medico = $id");
            $sql_espec = "INSERT INTO medico_especialidades (id_medico, id_especialidade) VALUES (?, ?)";
            $stmt_espec = $conexao->prepare($sql_espec);
            foreach ($_POST['especialidades'] as $id_especialidade) {
                $stmt_espec->bind_param("ii", $id, $id_especialidade);
                if (!$stmt_espec->execute()) throw new Exception("Erro ao vincular especialidade: " . $stmt_espec->error);
            }
            $stmt_espec->close();

            $conexao->commit();
            $_SESSION['success_message'] = "Médico atualizado com sucesso!";
        } catch (Exception $e) {
            $conexao->rollback();
            $_SESSION['error_message'] = $e->getMessage();
        }
        break;

    case 'toggle_status':
        $id = $_GET['id'];
        // Busca o status atual
        $result = $conexao->query("SELECT ativo FROM medicos WHERE id = $id");
        if ($result && $row = $result->fetch_assoc()) {
            $novo_status = $row['ativo'] ? 0 : 1;
            $conexao->query("UPDATE medicos SET ativo = $novo_status WHERE id = $id");
            $_SESSION['success_message'] = $novo_status ? "Médico ativado com sucesso!" : "Médico desativado com sucesso!";
        }
        break;
}

$conexao->close();
header("Location: medicos_listar.php");
exit();
?>