<?php
// Inicia a sessão no topo de qualquer script que precise dela
session_start();

// Inclui o arquivo de conexão. O '../' significa 'voltar uma pasta'
require_once '../conexao.php';

// Verifica se o formulário foi enviado
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $senha = $_POST['senha'];

    // Prepara a consulta para evitar injeção de SQL
    $sql = "SELECT id, nome, senha FROM administradores WHERE email = ?";
    $stmt = $conexao->prepare($sql);
    
    if ($stmt === false) {
        die("Erro ao preparar a query: " . $conexao->error);
    }
    
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 1) {
        $admin = $resultado->fetch_assoc();

        // Verifica a senha usando password_verify
        if (password_verify($senha, $admin['senha'])) {
            // Senha correta. Login bem-sucedido.
            // Armazena dados na sessão
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_nome'] = $admin['nome'];
            
            // Redireciona para o dashboard
            header("Location: dashboard.php");
            exit();
        } else {
            // Senha incorreta
            $_SESSION['login_error'] = "E-mail ou senha inválidos.";
            header("Location: index.php");
            exit();
        }
    } else {
        // Usuário não encontrado
        $_SESSION['login_error'] = "E-mail ou senha inválidos.";
        header("Location: index.php");
        exit();
    }

    $stmt->close();
    $conexao->close();
} else {
    // Se alguém tentar acessar o script diretamente, redireciona para o login
    header("Location: index.php");
    exit();
}
?>