<?php 
// O header já estará incluído pelas páginas 'adicionar' e 'editar'
include_once './_template/header.php';
?>

<h1 class="h3 mb-4 text-gray-800"><?php echo $titulo_pagina; ?></h1>

<div class="card shadow mb-4">
    <div class="card-body">
        <form action="especialidades_acao.php" method="POST">
            <input type="hidden" name="acao" value="<?php echo $acao; ?>">
            <?php if (isset($id)): ?>
                <input type="hidden" name="id" value="<?php echo $id; ?>">
            <?php endif; ?>

            <div class="mb-3">
                <label for="nome" class="form-label">Nome da Especialidade</label>
                <input type="text" class="form-control" id="nome" name="nome" value="<?php echo isset($nome) ? htmlspecialchars($nome) : ''; ?>" required>
            </div>
            
            <div class="mb-3">
                <label for="descricao" class="form-label">Descrição (opcional)</label>
                <textarea class="form-control" id="descricao" name="descricao" rows="4"><?php echo isset($descricao) ? htmlspecialchars($descricao) : ''; ?></textarea>
            </div>

            <div class="d-flex justify-content-end">
                <a href="especialidades_listar.php" class="btn btn-secondary me-2">Cancelar</a>
                <button type="submit" class="btn btn-primary">Salvar</button>
            </div>
        </form>
    </div>
</div>

<?php 
include_once './_template/footer.php'; 
?>