<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    // Se não estiver logado, não pode fazer nada
    header("Location: index.php");
    exit();
}

require_once '../conexao.php';

// Determina a ação a ser executada
$acao = $_POST['acao'] ?? $_GET['acao'] ?? '';

switch ($acao) {
    case 'adicionar':
        $nome = $_POST['nome'];
        $descricao = $_POST['descricao'];
        
        $sql = "INSERT INTO especialidades (nome, descricao) VALUES (?, ?)";
        $stmt = $conexao->prepare($sql);
        $stmt->bind_param("ss", $nome, $descricao);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Especialidade adicionada com sucesso!";
        } else {
            // Poderíamos ter uma mensagem de erro aqui
        }
        $stmt->close();
        break;

    case 'editar':
        $id = $_POST['id'];
        $nome = $_POST['nome'];
        $descricao = $_POST['descricao'];
        
        $sql = "UPDATE especialidades SET nome = ?, descricao = ? WHERE id = ?";
        $stmt = $conexao->prepare($sql);
        $stmt->bind_param("ssi", $nome, $descricao, $id);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Especialidade atualizada com sucesso!";
        }
        $stmt->close();
        break;

    case 'excluir':
        $id = $_GET['id'];
        
        $sql = "DELETE FROM especialidades WHERE id = ?";
        $stmt = $conexao->prepare($sql);
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Especialidade excluída com sucesso!";
        }
        $stmt->close();
        break;
}

$conexao->close();

// Redireciona de volta para a lista após a ação
header("Location: especialidades_listar.php");
exit();
?>