<?php
$titulo_pagina = "Check-in e Fila de Espera";
include_once './_template/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Check-in de Pacientes (Agendamentos de Hoje)</h1>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <div class="row">
            <div class="col-md-6">
                <input type="text" id="buscaPaciente" class="form-control" placeholder="Digite o nome do paciente para buscar...">
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" width="100%">
                <thead>
                    <tr>
                        <th>Horário</th>
                        <th>Paciente</th>
                        <th>Médico</th>
                        <th class="text-center">Status</th>
                        <th class="text-center" style="width: 30%;">Ação</th>
                    </tr>
                </thead>
                <tbody id="tabelaAgendamentos">
                    <tr><td colspan="5" class="text-center">Digite um nome para buscar ou deixe em branco para ver todos os agendamentos de hoje.</td></tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const buscaInput = document.getElementById('buscaPaciente');
    const tabelaBody = document.getElementById('tabelaAgendamentos');

    function buscarAgendamentos(termo = '') {
        tabelaBody.innerHTML = '<tr><td colspan="5" class="text-center">Buscando...</td></tr>';
        
        fetch(`../api/buscar_agendamentos.php?termo=${encodeURIComponent(termo)}`)
            .then(response => response.json())
            .then(data => {
                tabelaBody.innerHTML = ''; 
                if (data.length > 0) {
                    data.forEach(agendamento => {
                        const hora = new Date(agendamento.data_hora_agendamento).toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
                        const statusBadge = agendamento.check_in_realizado == 1 
                            ? '<span class="badge bg-success">Check-in Realizado</span>' 
                            : '<span class="badge bg-warning text-dark">Aguardando Check-in</span>';

                        // Lógica do botão e do NOVO MENU DE PRIORIDADE
                        const actionContent = agendamento.check_in_realizado == 1
                            ? '<button class="btn btn-secondary btn-sm" disabled>Finalizado</button>'
                            : `
                                <div class="input-group">
                                    <select class="form-select" id="prioridade_${agendamento.id}">
                                        <option value="1">Normal</option>
                                        <option value="2">Retorno Rápido (Verde)</option>
                                        <option value="3">Prioritário - Lei (Amarelo)</option>
                                        <option value="4">Urgente (Vermelho)</option>
                                    </select>
                                    <button class="btn btn-primary" type="button" onclick="realizarCheckin(${agendamento.id})">Fazer Check-in</button>
                                </div>
                            `;
                        
                        const row = `
                            <tr>
                                <td>${hora}</td>
                                <td>${agendamento.nome_paciente}</td>
                                <td>${agendamento.nome_medico}</td>
                                <td class="text-center">${statusBadge}</td>
                                <td class="text-center">${actionContent}</td>
                            </tr>
                        `;
                        tabelaBody.innerHTML += row;
                    });
                } else {
                    tabelaBody.innerHTML = '<tr><td colspan="5" class="text-center">Nenhum agendamento encontrado.</td></tr>';
                }
            });
    }

    buscarAgendamentos('');

    let timeoutId;
    buscaInput.addEventListener('keyup', function() {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(() => {
            buscarAgendamentos(this.value);
        }, 300);
    });
});

function realizarCheckin(agendamentoId) {
    const prioridadeSelect = document.getElementById(`prioridade_${agendamentoId}`);
    const prioridadeValue = prioridadeSelect.value;
    const prioridadeText = prioridadeSelect.options[prioridadeSelect.selectedIndex].text;

    if (!confirm(`Deseja fazer o check-in deste paciente com prioridade '${prioridadeText}'?`)) {
        return;
    }

    fetch('../api/realizar_checkin.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ 
            agendamento_id: agendamentoId,
            ordem_prioridade: prioridadeValue // Envia o número da prioridade
        })
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
        if (data.success) {
            document.getElementById('buscaPaciente').dispatchEvent(new Event('keyup'));
        }
    });
}
</script>

<?php include_once './_template/footer.php'; ?>