<?php
$titulo_pagina = "Agenda da Clínica";
include_once './_template/header.php';
require_once '../conexao.php';
$medicos = $conexao->query("SELECT id, nome_completo FROM medicos WHERE ativo = 1 ORDER BY nome_completo")->fetch_all(MYSQLI_ASSOC);
$pacientes = $conexao->query("SELECT id, nome_completo, cpf FROM pacientes ORDER BY nome_completo")->fetch_all(MYSQLI_ASSOC);
$especialidades = $conexao->query("SELECT id, nome FROM especialidades ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
$filtro_medico_id = $_GET['medico_id'] ?? 'todos';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CliniSys - Agenda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    <style>
        #agenda-container, .form-select, .btn, .fc { 
            font-family: 'Roboto', sans-serif !important; 
        }
        #calendario { 
            height: 80vh; 
        }
        .medico-legend {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin: 10px 0;
            padding: 10px;
            background: #f8f9fa;
            border-radius: 5px;
        }
        .medico-legend-item {
            display: flex;
            align-items: center;
            gap: 5px;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 0.9em;
        }
        .medico-legend-color {
            width: 15px;
            height: 15px;
            border-radius: 3px;
        }
        .fc .fc-toolbar-title {
            font-family: 'Roboto', sans-serif !important;
            font-size: 1.5rem;
            font-weight: 700;
            color: #222;
        }
        .fc .fc-col-header-cell-cushion {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            padding: 8px 0 0 8px;
            font-family: 'Roboto', sans-serif !important;
            background: transparent;
        }
        .fc .fc-custom-day-header {
            font-size: 0.8em !important;
            color: #666 !important;
            font-weight: 400 !important;
            margin-bottom: 2px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-custom-day-date-row {
            display: flex;
            flex-direction: row;
            align-items: baseline;
            gap: 2px;
        }
        .fc .fc-custom-day-number {
            font-size: 2.1em;
            font-weight: 400 !important;
            color: #222;
            line-height: 1;
            display: inline-block;
            text-decoration: none !important;
        }
        .fc .fc-custom-day-month {
            font-size: 0.85em !important;
            color: #bbb !important;
            font-weight: 300 !important;
            margin-left: 2px !important;
            vertical-align: middle !important;
            letter-spacing: 0.5px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-daygrid-day-number, .fc .fc-timegrid-axis-cushion {
            font-family: 'Roboto', sans-serif !important;
            font-size: 1.2rem;
            font-weight: 400;
            color: #222;
            padding: 0 0 0 8px;
        }
        .fc .fc-daygrid-day-top {
            flex-direction: column;
            align-items: flex-start;
            padding-left: 8px;
            padding-top: 8px;
        }
        .fc .fc-daygrid-day {
            background: #fff;
            border-radius: 8px;
            margin: 2px;
        }
        .fc .fc-scrollgrid-section-header > th {
            background: #f8f9fa;
            border: none;
        }
        .fc .fc-scrollgrid-section-body > td {
            background: #fff;
            border: none;
        }
        .fc .fc-timegrid-slot-label {
            font-family: 'Roboto', sans-serif !important;
            font-size: 1rem;
            font-weight: 400;
            color: #888;
            padding-left: 8px;
        }
        .fc .fc-timegrid-slot {
            border-color: #f0f0f0;
        }
        .fc .fc-timegrid-axis-cushion {
            color: #888;
            font-size: 1rem;
            font-weight: 400;
        }
        .fc .fc-day-today {
            background: #e3f2fd !important;
        }
        .fc .fc-daygrid-day.fc-day-today {
            background: #e3f2fd !important;
        }
        .fc .fc-daygrid-day-number {
            color: #222;
            font-weight: 700;
        }
        .fc .fc-daygrid-day.fc-day-past {
            opacity: 0.7;
        }
        .fc .fc-scrollgrid, .fc .fc-scrollgrid-section {
            border: none !important;
        }
        .fc .fc-col-header-cell .fc-custom-day-number,
        .fc .fc-col-header-cell .fc-custom-day-number *,
        .fc .fc-col-header-cell-cushion .fc-custom-day-number,
        .fc .fc-col-header-cell-cushion .fc-custom-day-number *,
        .fc .fc-col-header-cell a .fc-custom-day-number,
        .fc .fc-col-header-cell a .fc-custom-day-number * {
            font-family: 'Roboto', sans-serif !important;
            font-weight: 300 !important;
            font-variation-settings: 'wght' 300 !important;
            color: #222 !important;
            text-decoration: none !important;
            background: none !important;
            line-height: 1 !important;
            display: inline-block !important;
            font-size: 1.5em !important;
        }
        .fc .fc-custom-day-number, .fc .fc-custom-day-number a {
            font-size: 2.1em !important;
            font-weight: 400 !important;
            color: #222 !important;
            line-height: 1 !important;
            display: inline-block !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-custom-day-month, .fc .fc-custom-day-month a {
            font-size: 0.85em !important;
            color: #bbb !important;
            font-weight: 300 !important;
            margin-left: 2px !important;
            vertical-align: middle !important;
            letter-spacing: 0.5px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc .fc-custom-day-header, .fc .fc-custom-day-header a {
            font-size: 0.8em !important;
            color: #666 !important;
            font-weight: 400 !important;
            margin-bottom: 2px !important;
            text-decoration: none !important;
            background: none !important;
        }
        .fc-event, .fc-event-main {
            font-size: 12px !important;
        }
        /* Cores baseadas no status */
        .fc-event.status-agendado {
            background-color: #5bb4ee !important;
            color: #fff !important;
        }
        .fc-event.status-confirmado {
            background-color: #28a745 !important;
            color: #fff !important;
        }
        .fc-event.status-fila {
            background-color: #fd7e14 !important;
            color: #fff !important;
        }
        .fc-event.status-atendimento {
            background-color: #6f42c1 !important;
            color: #fff !important;
        }
        .fc-event.status-cancelado {
            background-color: #dc3545 !important;
            color: #fff !important;
        }
    </style>
</head>
<body>
    <div id="agenda-container">
        <div class="card shadow mb-4">
            <div class="card-body">
                <form id="filter-form" action="agenda_geral.php" method="GET" class="d-flex align-items-center">
                    <label for="medico_filtro" class="me-2 fw-bold">Médico:</label>
                    <select name="medico_id" id="medico_filtro" class="form-select" style="width: 250px;" onchange="this.form.submit()">
                        <option value="todos">Todos os médicos</option>
                        <?php foreach ($medicos as $medico): ?>
                            <option value="<?php echo $medico['id']; ?>" <?php echo ($filtro_medico_id == $medico['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($medico['nome_completo']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>
                
                <?php if ($filtro_medico_id === 'todos'): ?>
                    <div class="medico-legend" id="medico-legend">
                        <div class="medico-legend-item">
                            <div class="medico-legend-color" style="background-color: #5bb4ee;"></div>
                            <span>Agendado</span>
                        </div>
                        <div class="medico-legend-item">
                            <div class="medico-legend-color" style="background-color: #28a745;"></div>
                            <span>Confirmado</span>
                        </div>
                        <div class="medico-legend-item">
                            <div class="medico-legend-color" style="background-color: #fd7e14;"></div>
                            <span>Em Fila</span>
                        </div>
                        <div class="medico-legend-item">
                            <div class="medico-legend-color" style="background-color: #6f42c1;"></div>
                            <span>Em Atendimento</span>
                        </div>
                        <div class="medico-legend-item">
                            <div class="medico-legend-color" style="background-color: #dc3545;"></div>
                            <span>Cancelado</span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="card shadow">
            <div class="card-body">
                <div id="calendario"></div>
            </div>
        </div>
    </div>
    
    <button class="add-appointment-btn" id="btnAddAppointment" title="Novo Agendamento" data-bs-toggle="modal" data-bs-target="#modalNovoAgendamento">
        <i class="fas fa-plus"></i>
    </button>

    <div class="modal fade" id="modalDetalhes" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Detalhes do Agendamento</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p><strong>Paciente:</strong> <span id="detalhePaciente"></span></p>
                    <p><strong>Médico:</strong> <span id="detalheMedico"></span></p>
                    <p><strong>Horário:</strong> <span id="detalheHorario"></span></p>
                    <div class="mb-3">
                        <label for="statusAgendamento" class="form-label"><strong>Status:</strong></label>
                        <select id="statusAgendamento" class="form-select">
                            <option value="agendado">Agendado</option>
                            <option value="confirmado">Confirmado</option>
                            <option value="fila">Em Fila de Espera</option>
                            <option value="atendimento">Em Atendimento</option>
                            <option value="cancelado">Cancelado</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" id="btnExcluir" class="btn btn-danger">Cancelar Agendamento</button>
                    <div>
                        <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">Fechar</button>
                        <button type="button" id="btnSalvarStatus" class="btn btn-primary">Salvar Status</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNovoAgendamento" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form id="formNovoAgendamento">
                    <div class="modal-header">
                        <h5 class="modal-title">Novo Agendamento</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label for="pacienteId" class="form-label">Paciente</label>
                                <select id="pacienteId" name="pacienteId" class="form-control" style="width: 100%;" required></select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="medicoId" class="form-label">Médico</label>
                                <select id="medicoId" name="medicoId" class="form-select" required>
                                    <option value="">Selecione...</option>
                                    <?php foreach ($medicos as $m): ?>
                                        <option value='<?php echo $m['id']; ?>'><?php echo htmlspecialchars($m['nome_completo']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="especialidadeId" class="form-label">Especialidade</label>
                                <select id="especialidadeId" name="especialidadeId" class="form-select" required>
                                    <?php foreach ($especialidades as $e): ?>
                                        <option value='<?php echo $e['id']; ?>'><?php echo htmlspecialchars($e['nome']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="data" class="form-label">Data</label>
                                <input type="date" id="data" name="data" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="horario_disponivel" class="form-label">Horários Disponíveis</label>
                                <select id="horario_disponivel" name="horario_disponivel" class="form-select" required>
                                    <option value="">Selecione primeiro a Data e o Médico</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/locales/pt-br.global.min.js'></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            const calendarioEl = document.getElementById('calendario');
            const modalDetalhes = new bootstrap.Modal(document.getElementById('modalDetalhes'));
            const modalNovoAgendamento = new bootstrap.Modal(document.getElementById('modalNovoAgendamento'));
            let eventoClicado = null;

            // Inicializa a busca de pacientes com Select2
            $('#pacienteId').select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#modalNovoAgendamento'),
                placeholder: 'Digite nome, CPF ou celular...',
                language: {
                    inputTooShort: function() {
                        return 'Digite pelo menos 2 caracteres';
                    },
                    noResults: function() {
                        return 'Nenhum resultado encontrado';
                    },
                    searching: function() {
                        return 'Buscando...';
                    },
                    loadingMore: function() {
                        return 'Carregando mais resultados...';
                    },
                    errorLoading: function() {
                        return 'Erro ao carregar resultados';
                    }
                },
                ajax: {
                    url: '../api/get_pacientes_simplificado.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return { results: data.results };
                    },
                    cache: true
                }
            });

            // Elementos do formulário do modal
            const medicoSelectModal = document.getElementById('medicoId');
            const dataInputModal = document.getElementById('data');
            const horariosSelectModal = document.getElementById('horario_disponivel');

            // Função para buscar horários disponíveis
            function buscarHorarios() {
                const medicoId = medicoSelectModal.value;
                const data = dataInputModal.value;

                if (medicoId && data) {
                    horariosSelectModal.disabled = true;
                    horariosSelectModal.innerHTML = '<option>Buscando...</option>';

                    fetch(`../api/get_slots_disponiveis.php?medico_id=${medicoId}&data=${data}`)
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Erro ao buscar horários');
                            }
                            return response.json();
                        })
                        .then(slots => {
                            horariosSelectModal.innerHTML = '<option value="">Selecione um horário</option>';
                            if (slots.length > 0) {
                                slots.forEach(slot => {
                                    horariosSelectModal.add(new Option(slot, slot));
                                });
                            } else {
                                horariosSelectModal.innerHTML = '<option value="">Nenhum horário livre</option>';
                            }
                        })
                        .catch(error => {
                            console.error('Erro:', error);
                            horariosSelectModal.innerHTML = '<option value="">Erro ao carregar horários</option>';
                        })
                        .finally(() => {
                            horariosSelectModal.disabled = false;
                        });
                }
            }

            // Adiciona "escutadores" para buscar os horários quando o médico ou a data mudam
            medicoSelectModal.addEventListener('change', buscarHorarios);
            dataInputModal.addEventListener('change', buscarHorarios);

            const calendar = new FullCalendar.Calendar(calendarioEl, {
                locale: 'pt-br',
                initialView: 'timeGridWeek',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                buttonText: {
                    today: 'Hoje',
                    month: 'Mês',
                    week: 'Semana',
                    day: 'Dia'
                },
                firstDay: 1,
                allDaySlot: false,
                nowIndicator: true,
                scrollTime: new Date().toTimeString().substring(0, 5),
                slotDuration: '00:15:00',
                slotLabelInterval: '01:00:00',
                slotLabelFormat: {
                    hour: '2-digit',
                    minute: '2-digit',
                    hour12: false,
                    omitZeroMinute: false
                },
                dayHeaderContent: function(arg) {
                    const diaSemana = arg.date.toLocaleDateString('pt-BR', { weekday: 'short' });
                    const dia = arg.date.getDate().toString().padStart(2, '0');
                    const mes = (arg.date.getMonth() + 1).toString().padStart(2, '0');
                    return {
                        html: `<span class='fc-custom-day-header'>${diaSemana.charAt(0).toUpperCase() + diaSemana.slice(1)}.</span>
                               <span class='fc-custom-day-date-row'>
                                   <span class='fc-custom-day-number'>${dia}</span>
                                   <span class='fc-custom-day-month'>/${mes}</span>
                               </span>`
                    };
                },
                events: {
                    url: '../api/get_todos_agendamentos.php',
                    extraParams: function() {
                        return {
                            medico_id: document.getElementById('medico_filtro').value
                        };
                    },
                    eventClassNames: function(arg) {
                        const status = arg.event.extendedProps.status || 'agendado';
                        return ['status-' + status];
                    }
                },
                editable: true,
                eventClick: function(info) {
                    eventoClicado = info.event;
                    $('#detalhePaciente').text(info.event.title);
                    $('#detalheMedico').text(info.event.extendedProps.nome_medico);
                    $('#detalheHorario').text(info.event.start.toLocaleString('pt-BR', {
                        dateStyle: 'short',
                        timeStyle: 'short'
                    }));
                    $('#statusAgendamento').val(info.event.extendedProps.status);
                    modalDetalhes.show();
                },
                eventDrop: function(info) {
                    if (!confirm("Tem certeza que deseja reagendar esta consulta?")) {
                        info.revert();
                    } else {
                        fetch('../api/atualizar_agendamento.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({
                                id: info.event.id,
                                start: info.event.start.toISOString()
                            })
                        })
                        .then(r => r.json())
                        .then(res => {
                            if (!res.success) {
                                alert(res.message);
                                info.revert();
                            }
                        });
                    }
                },
                dateClick: function(info) {
                    $('#formNovoAgendamento').trigger("reset");
                    $('#pacienteId').val(null).trigger('change');
                    $('#data').val(info.dateStr.substring(0, 10));
                    $('#hora').val(info.dateStr.substring(11, 16));
                    modalNovoAgendamento.show();
                }
            });
            calendar.render();

            // Recarrega os eventos quando o filtro de médico for alterado
            document.getElementById('medico_filtro').addEventListener('change', function() {
                calendar.refetchEvents();
            });

            // Ações dos Modais
            $('#btnExcluir').on('click', function() {
                if (eventoClicado && confirm("Atenção! Esta ação é permanente. Deseja cancelar este agendamento?")) {
                    fetch('../api/excluir_agendamento.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify({ id: eventoClicado.id })
                    })
                    .then(r => r.json())
                    .then(res => {
                        alert(res.message);
                        if (res.success) {
                            eventoClicado.remove();
                            modalDetalhes.hide();
                        }
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        alert('Erro ao excluir agendamento');
                    });
                }
            });

            // Adiciona evento para o botão de salvar status
            $('#btnSalvarStatus').on('click', function() {
                if (eventoClicado) {
                    const novoStatus = $('#statusAgendamento').val();
                    console.log('ID do agendamento:', eventoClicado.id);
                    console.log('Novo status:', novoStatus);
                    
                    const dados = {
                        id: eventoClicado.id,
                        status: novoStatus
                    };
                    
                    console.log('Dados enviados:', dados);
                    
                    fetch('../api/atualizar_agendamento.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify(dados)
                    })
                    .then(r => r.json())
                    .then(res => {
                        console.log('Resposta da API:', res);
                        if (res.success) {
                            // Atualiza o evento no calendário
                            const eventoAtualizado = {
                                ...eventoClicado.toPlainObject(),
                                extendedProps: {
                                    ...eventoClicado.extendedProps,
                                    status: novoStatus
                                },
                                backgroundColor: getStatusColor(novoStatus),
                                classNames: ['status-' + novoStatus]
                            };
                            
                            eventoClicado.remove();
                            calendar.addEvent(eventoAtualizado);
                            modalDetalhes.hide();
                        } else {
                            alert(res.message);
                            $('#statusAgendamento').val(eventoClicado.extendedProps.status);
                        }
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        alert('Erro ao atualizar status');
                        $('#statusAgendamento').val(eventoClicado.extendedProps.status);
                    });
                }
            });

            // Função para obter a cor baseada no status
            function getStatusColor(status) {
                const cores = {
                    'agendado': '#5bb4ee',
                    'confirmado': '#28a745',
                    'fila': '#fd7e14',
                    'atendimento': '#6f42c1',
                    'cancelado': '#dc3545'
                };
                return cores[status] || '#5bb4ee';
            }

            // Adiciona evento para fechar o modal sem salvar
            $('#modalDetalhes .btn-close, #modalDetalhes .btn-secondary').on('click', function() {
                $('#statusAgendamento').val(eventoClicado.extendedProps.status);
            });

            // Lógica para salvar o formulário
            $('#formNovoAgendamento').on('submit', function(e) {
                e.preventDefault();
                const data = $('#data').val();
                const hora = $('#horario_disponivel').val();
                
                if (!hora) {
                    alert('Por favor, selecione um horário disponível.');
                    return;
                }

                const dados = {
                    pacienteId: $('#pacienteId').val(),
                    medicoId: $('#medicoId').val(),
                    especialidadeId: $('#especialidadeId').val(),
                    start: `${data}T${hora}`
                };

                fetch('../api/salvar_agendamento.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify(dados)
                })
                .then(r => r.json())
                .then(res => {
                    alert(res.message);
                    if (res.success) {
                        modalNovoAgendamento.hide();
                        calendar.refetchEvents();
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    alert('Erro ao salvar agendamento');
                });
            });
        });
    </script>
</body>
</html>