<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="refresh" content="300"> 
    <title>Painel de Chamadas - CliniSys</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@700&family=Roboto:wght@400&display=swap');
        body { background-color: #0d3b66; color: #f4f1de; font-family: 'Roboto', sans-serif; overflow: hidden; }
        .container-fluid { display: flex; height: 100vh; }
        .main-call { flex-grow: 1; display: flex; flex-direction: column; justify-content: center; align-items: center; background-color: #f9a826; color: #0d3b66; padding: 2rem; transition: background-color 0.5s ease; }
        .main-call.blink { animation: blink-animation 1s ease; }
        @keyframes blink-animation { 50% { background-color: #fcae1e; } }
        .main-call .patient-name { font-family: 'Montserrat', sans-serif; font-size: 8vw; font-weight: 700; text-transform: uppercase; line-height: 1.1; text-align: center; }
        .main-call .consultorio { font-family: 'Montserrat', sans-serif; font-size: 5vw; font-weight: 700; margin-top: 1rem; }
        .last-calls { min-width: 35%; max-width: 35%; background-color: #0d3b66; padding: 2rem; display: flex; flex-direction: column; }
        .last-calls h2 { font-family: 'Montserrat', sans-serif; font-weight: 700; color: #f9a826; text-align: center; margin-bottom: 2rem; }
        .last-calls .call-item { background-color: rgba(244, 241, 222, 0.1); border-radius: 0.5rem; padding: 1rem; margin-bottom: 1rem; display: flex; justify-content: space-between; }
        .last-calls .patient-name-small { font-size: 2vw; font-weight: bold; text-transform: uppercase; }
        .last-calls .consultorio-small { font-size: 2vw; font-weight: bold; color: #f9a826; }
        #clock { font-family: 'Montserrat', sans-serif; font-size: 3vw; font-weight: 700; text-align: center; margin-top: auto; }
    </style>
</head>
<body>
    <div class="container-fluid p-0">
        <div id="main-call-panel" class="main-call">
            <div id="main-patient-name" class="patient-name">Aguardando...</div>
            <div id="main-consultorio" class="consultorio"></div>
        </div>
        <div class="last-calls">
            <h2>ÚLTIMAS CHAMADAS</h2>
            <div id="last-calls-list"></div>
            <div id="clock"></div>
        </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const mainCallPanel = document.getElementById('main-call-panel');
    const mainPatientNameEl = document.getElementById('main-patient-name');
    const mainConsultorioEl = document.getElementById('main-consultorio');
    const lastCallsListEl = document.getElementById('last-calls-list');
    const clockEl = document.getElementById('clock');
    
    // CORREÇÃO: Vamos guardar o ID da última chamada, e não o nome.
    let ultimoIdAnunciado = null;

    function falarTexto(texto) {
        if ('speechSynthesis' in window) {
            const utterance = new SpeechSynthesisUtterance(texto);
            utterance.lang = 'pt-BR';
            utterance.rate = 0.9;
            window.speechSynthesis.speak(utterance);
        } else {
            console.log('API de Síntese de Voz não suportada.');
        }
    }

    function atualizarPainel() {
        fetch('api/get_chamadas_tv.php')
        .then(response => response.json())
        .then(data => {
            if (data.length > 0) {
                const chamadaMaisRecente = data[0];
                mainPatientNameEl.textContent = chamadaMaisRecente.nome_paciente;
                mainConsultorioEl.textContent = chamadaMaisRecente.numero_consultorio;

                // CORREÇÃO: A lógica agora compara o ID da chamada.
                if (chamadaMaisRecente.id !== ultimoIdAnunciado) {
                    ultimoIdAnunciado = chamadaMaisRecente.id; // Atualiza o ID da última chamada
                    const textoParaFalar = `${chamadaMaisRecente.nome_paciente}, por favor, dirija-se ao ${chamadaMaisRecente.numero_consultorio}.`;
                    falarTexto(textoParaFalar);
                    
                    // Adiciona um efeito visual de "piscar" para novas chamadas
                    mainCallPanel.classList.add('blink');
                    setTimeout(() => mainCallPanel.classList.remove('blink'), 1000);
                }

                lastCallsListEl.innerHTML = '';
                for (let i = 1; i < data.length; i++) {
                    const chamada = data[i];
                    const item = `
                        <div class="call-item">
                            <span class="patient-name-small">${chamada.nome_paciente}</span>
                            <span class="consultorio-small">${chamada.numero_consultorio}</span>
                        </div>
                    `;
                    lastCallsListEl.innerHTML += item;
                }

            } else {
                mainPatientNameEl.textContent = 'Aguardando...';
                mainConsultorioEl.textContent = '';
                lastCallsListEl.innerHTML = '';
                ultimoIdAnunciado = null; // Reseta o ID se a fila estiver vazia
            }
        });
    }
    
    function atualizarRelogio() {
        // ... (código do relógio permanece o mesmo)
        const agora = new Date();
        const horas = String(agora.getHours()).padStart(2, '0');
        const minutos = String(agora.getMinutes()).padStart(2, '0');
        const segundos = String(agora.getSeconds()).padStart(2, '0');
        clockEl.textContent = `${horas}:${minutos}:${segundos}`;
    }

    atualizarPainel();
    atualizarRelogio();
    
    setInterval(atualizarPainel, 7000);
    setInterval(atualizarRelogio, 1000);
});
</script>
</body>
</html>