<?php
session_start();
if (!isset($_SESSION['medico_id'])) {
    header("Location: index.php");
    exit();
}
$nome_medico = $_SESSION['medico_nome'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sua Fila de Atendimento - CliniSys</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body { background-color: #f0f2f5; }
        /* Adicionando classes de borda e cor de fundo para as prioridades */
        .priority-4 { border-left: 7px solid #dc3545; } /* Vermelho */
        .priority-3 { border-left: 7px solid #ffc107; } /* Amarelo */
        .priority-2 { border-left: 7px solid #198754; } /* Verde */
        
        .status-chamado { background-color: #e2e3e5; }
        .status-em-atendimento { background-color: #cff4fc; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="#"><i class="bi bi-heart-pulse-fill"></i> CliniSys Médico</a>
            <span class="navbar-text text-white-50">Dr(a). <?php echo htmlspecialchars($nome_medico); ?></span>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Sair</a>
        </div>
    </nav>

    <div class="container py-4">
        <div id="area_atendimento_atual" class="mb-4"></div>
        <div id="area_proximo_paciente" class="mb-4"></div>
        
        <h4 class="text-muted mb-3" id="titulo_fila_espera" style="display: none;">Aguardando na Fila</h4>
        <div id="lista_espera_restante"></div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const areaAtendimento = document.getElementById('area_atendimento_atual');
    const areaProximo = document.getElementById('area_proximo_paciente');
    const areaRestante = document.getElementById('lista_espera_restante');
    const tituloFilaEspera = document.getElementById('titulo_fila_espera');

    const prioridades = {
        '4': { texto: 'URGENTE', cor: 'danger' },
        '3': { texto: 'PRIORITÁRIO (LEI)', cor: 'warning' },
        '2': { texto: 'RETORNO RÁPIDO', cor: 'success' }
    };

    function getPriorityBadge(level) {
        if (prioridades[level]) {
            return `<span class="badge bg-${prioridades[level].cor} me-2">${prioridades[level].texto}</span>`;
        }
        return '';
    }

    function renderizarFila(fila) {
        let pacienteEmAtendimento = fila.find(p => p.status_fila === 'Em Atendimento');
        let pacienteChamado = fila.find(p => p.status_fila === 'Chamado');
        let aguardando = fila.filter(p => p.status_fila === 'Aguardando');
        
        areaAtendimento.innerHTML = '';
        areaProximo.innerHTML = '';
        areaRestante.innerHTML = '';
        tituloFilaEspera.style.display = 'none';

        if (pacienteEmAtendimento) {
            const card = `
                <div class="card shadow border-primary mb-4">
                    <div class="card-header bg-primary text-white">EM ATENDIMENTO</div>
                    <div class="card-body text-center">
                        ${getPriorityBadge(pacienteEmAtendimento.ordem_prioridade)}
                        <h2 class="card-title mt-2">${pacienteEmAtendimento.nome_paciente}</h2>
                        <hr>
                        <div class="d-grid gap-2">
                             <button class="btn btn-success btn-lg" onclick="atualizarStatus(${pacienteEmAtendimento.id_fila}, 'Atendido', true)">
                                <i class="bi bi-check-circle-fill"></i> Finalizar e Chamar Próximo
                            </button>
                            <button class="btn btn-outline-secondary btn-sm" onclick="atualizarStatus(${pacienteEmAtendimento.id_fila}, 'Atendido', false)">
                                Apenas Finalizar
                            </button>
                        </div>
                    </div>
                </div>`;
            areaAtendimento.innerHTML = card;
        }
        else if (pacienteChamado) {
            const card = `
                <div class="card shadow border-info">
                    <div class="card-header bg-info text-dark">PACIENTE CHAMADO</div>
                    <div class="card-body text-center">
                         ${getPriorityBadge(pacienteChamado.ordem_prioridade)}
                        <h2 class="card-title mt-2">${pacienteChamado.nome_paciente}</h2>
                        <p class="text-muted">Aguardando paciente no consultório...</p>
                        <hr>
                        <div class="d-grid gap-2">
                            <button class="btn btn-info btn-lg" onclick="atualizarStatus(${pacienteChamado.id_fila}, 'Em Atendimento')">
                                <i class="bi bi-play-circle-fill"></i> Iniciar Atendimento
                            </button>
                             <button class="btn btn-outline-secondary btn-sm mt-2" onclick="atualizarStatus(${pacienteChamado.id_fila}, 'Chamado')">
                                Chamar Novamente (Voz)
                            </button>
                        </div>
                    </div>
                </div>`;
            areaAtendimento.innerHTML = card;
        }
        
        else if (aguardando.length > 0) {
            const proximo = aguardando.shift(); 
            const card = `
                <div class="card shadow priority-${proximo.ordem_prioridade}">
                    <div class="card-header">PRÓXIMO PACIENTE</div>
                    <div class="card-body text-center">
                        ${getPriorityBadge(proximo.ordem_prioridade)}
                        <h2 class="card-title mt-2">${proximo.nome_paciente}</h2>
                        <p class="text-muted">Chegada: ${new Date(proximo.hora_chegada).toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' })}</p>
                        <hr>
                        <button class="btn btn-primary btn-lg w-100" onclick="atualizarStatus(${proximo.id_fila}, 'Chamado')">
                           <i class="bi bi-megaphone-fill"></i> Chamar Paciente
                        </button>
                    </div>
                </div>`;
            areaProximo.innerHTML = card;
        }

        if (aguardando.length > 0) {
            tituloFilaEspera.style.display = 'block';
            aguardando.forEach(paciente => {
                const card = `
                    <div class="card shadow-sm mb-2 priority-${paciente.ordem_prioridade}">
                        <div class="card-body d-flex justify-content-between align-items-center p-3">
                            <div>
                                ${getPriorityBadge(paciente.ordem_prioridade)}
                                <h5 class="mb-0 d-inline">${paciente.nome_paciente}</h5>
                            </div>
                            <button class="btn btn-outline-primary btn-sm" onclick="atualizarStatus(${paciente.id_fila}, 'Chamado')">Chamar</button>
                        </div>
                    </div>`;
                areaRestante.innerHTML += card;
            });
        } else if (!pacienteEmAtendimento && !pacienteChamado && areaProximo.innerHTML === '') {
             areaRestante.innerHTML = '<div class="alert alert-success text-center">Nenhum paciente aguardando no momento.</div>';
        }
    }

    // Função principal que busca os dados da fila
    window.atualizarFila = function() {
        fetch('../api/get_fila_medico.php')
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    areaRestante.innerHTML = `<div class="alert alert-danger">${data.error}</div>`;
                    return;
                }
                renderizarFila(data);
            });
    }

    // Função que atualiza o status de um paciente
    window.atualizarStatus = function(idFila, novoStatus, chamarProximo = false) {
        const confirmMsg = `Tem certeza que deseja alterar o status para "${novoStatus}"?`;
        // Não pede confirmação para a chamada principal ou para iniciar atendimento
        if (novoStatus !== 'Chamado' && novoStatus !== 'Em Atendimento' && !confirm(confirmMsg)) return;

        fetch('../api/atualizar_status_fila.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ 
                id_fila: idFila, 
                novo_status: novoStatus,
                chamar_proximo: chamarProximo // Envia a informação extra
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // ATUALIZAÇÃO IMEDIATA: Chama a função de atualizar a fila assim que o servidor confirma o sucesso.
                atualizarFila();
            } else {
                alert('Erro: ' + data.message);
            }
        });
    }

    // Inicia o ciclo de atualização
    atualizarFila();
    // ATUALIZAÇÃO DO INTERVALO: Diminuímos o tempo para 5 segundos para atualizações de fundo.
    setInterval(atualizarFila, 5000); 
});
</script>
</body>
</html>