<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado.']);
    exit;
}
require_once '../conexao.php';

$dados = json_decode(file_get_contents('php://input'), true);
$novaOrdem = $dados['nova_ordem'] ?? [];

if (empty($novaOrdem)) {
    echo json_encode(['success' => false, 'message' => 'Nenhuma ordem recebida.']);
    exit;
}

$conexao->begin_transaction();
try {
    // Prepara a query uma vez
    $sql = "UPDATE fila_espera SET ordem_manual = ? WHERE id = ?";
    $stmt = $conexao->prepare($sql);

    // Loop para atualizar a ordem de cada paciente
    foreach ($novaOrdem as $index => $id_fila) {
        $ordem = $index + 1; // A ordem começa em 1, 2, 3...
        $stmt->bind_param("ii", $ordem, $id_fila);
        $stmt->execute();
    }

    $conexao->commit();
    echo json_encode(['success' => true, 'message' => 'Ordem da fila atualizada com sucesso.']);

} catch (Exception $e) {
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => 'Erro no banco de dados: ' . $e->getMessage()]);
}

$stmt->close();
$conexao->close();
?>