<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

// Função para gerar uma cor consistente para cada médico
function gerarCorPorId($id) {
    $hash = crc32("medico_id_" . $id);
    $r = ($hash & 0xFF0000) >> 16;
    $g = ($hash & 0x00FF00) >> 8;
    $b = $hash & 0x0000FF;
    // Garante cores mais escuras para o texto branco ficar legível
    $r = floor($r * 0.75); $g = floor($g * 0.75); $b = floor($b * 0.75);
    return sprintf('#%02x%02x%02x', $r, $g, $b);
}

// SQL para buscar todos os agendamentos
$sql = "SELECT 
            a.id,
            a.data_hora_agendamento as start,
            DATE_ADD(a.data_hora_agendamento, INTERVAL m.duracao_consulta_min MINUTE) as end,
            p.nome_completo as nome_paciente,
            m.nome_completo as nome_medico,
            a.id_medico,
            e.nome as especialidade
        FROM 
            agendamentos a
        INNER JOIN 
            pacientes p ON a.id_paciente = p.id
        INNER JOIN 
            medicos m ON a.id_medico = m.id
        INNER JOIN
            especialidades e ON a.id_especialidade_agendada = e.id
        WHERE 
            m.ativo = 1
        ORDER BY 
            a.data_hora_agendamento ASC";

$resultado = $conexao->query($sql);
$agendamentos = [];

if ($resultado) {
    while ($ag = $resultado->fetch_assoc()) {
        // Formata o título com informações do paciente e médico
        $hora_inicio = date("H:i", strtotime($ag['start']));
        $hora_fim = date("H:i", strtotime($ag['end']));
        $ag['title'] = sprintf(
            "%s - %s\n%s\nDr(a). %s - %s",
            $hora_inicio,
            $hora_fim,
            mb_strtoupper($ag['nome_paciente'], 'UTF-8'),
            $ag['nome_medico'],
            $ag['especialidade']
        );
        
        // Adiciona as cores
        $ag['color'] = gerarCorPorId($ag['id_medico']);
        $ag['backgroundColor'] = $ag['color'];
        $ag['borderColor'] = $ag['color'];
        
        $agendamentos[] = $ag;
    }
}

$conexao->close();
echo json_encode($agendamentos);
?>