<?php
header('Content-Type: application/json');
require_once '../conexao.php';

$idEspecialidade = $_GET['especialidade_id'] ?? 0;

if ($idEspecialidade > 0) {
    $sql = "SELECT m.id, m.nome_completo 
            FROM medicos m
            JOIN medico_especialidades me ON m.id = me.id_medico
            WHERE m.ativo = 1 AND me.id_especialidade = ?
            ORDER BY m.nome_completo";
    
    $stmt = $conexao->prepare($sql);
    $stmt->bind_param("i", $idEspecialidade);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $medicos = $resultado->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
} else {
    $medicos = [];
}

echo json_encode($medicos);
$conexao->close();
?>