<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

// Array de cores para os médicos
$cores = [
    '#28a745', // Verde
    '#007bff', // Azul
    '#dc3545', // Vermelho
    '#ffc107', // Amarelo
    '#17a2b8', // Azul claro
    '#6610f2', // Roxo
    '#fd7e14', // Laranja
    '#20c997', // Verde água
    '#e83e8c', // Rosa
    '#6f42c1'  // Roxo escuro
];

// Verifica se é para buscar todos os médicos ou um específico
$idMedico = $_GET['medico_id'] ?? 0;
$buscarTodosMedicos = ($idMedico === 'todos');

// Se não for buscar todos e o ID não for válido, retorna vazio
if (!$buscarTodosMedicos && (!is_numeric($idMedico) || $idMedico <= 0)) {
    echo json_encode([]); // Retorna uma lista vazia se nenhum médico válido for selecionado
    exit;
}

$eventos = [];
$start_date_str = $_GET['start'] ?? date('Y-m-d');
$end_date_str = $_GET['end'] ?? date('Y-m-d', strtotime('+1 month'));

// Se buscar todos os médicos, precisamos de uma lista de IDs
$medicos_ids = [];
if ($buscarTodosMedicos) {
    $result_medicos = $conexao->query("SELECT id FROM medicos WHERE ativo = 1");
    while ($medico = $result_medicos->fetch_assoc()) {
        $medicos_ids[] = $medico['id'];
    }
} else {
    $medicos_ids[] = $idMedico;
}

// Para cada médico, buscar os horários
foreach ($medicos_ids as $index => $id_medico_atual) {
    // Seleciona uma cor para o médico (cicla através do array de cores)
    $cor_medico = $cores[$index % count($cores)];
    
    // Busca dados do médico (duração da consulta e nome)
    $stmt_medico = $conexao->prepare("SELECT duracao_consulta_min, nome_completo FROM medicos WHERE id = ?");
    $stmt_medico->bind_param("i", $id_medico_atual);
    $stmt_medico->execute();
    $medico_info = $stmt_medico->get_result()->fetch_assoc();
    $duracao_slot = $medico_info['duracao_consulta_min'] ?? 30;
    $nome_medico = $medico_info['nome_completo'] ?? 'Médico';
    $stmt_medico->close();

    // Busca jornada de trabalho
    $stmt_jornada = $conexao->prepare("SELECT dia_semana, hora_inicio, hora_fim FROM horarios_trabalho WHERE id_medico = ? AND ativo = 1");
    $stmt_jornada->bind_param("i", $id_medico_atual);
    $stmt_jornada->execute();
    $jornada_semanal = [];
    $resultado_jornada = $stmt_jornada->get_result();
    while($row = $resultado_jornada->fetch_assoc()) {
        $jornada_semanal[$row['dia_semana']] = $row;
    }
    $stmt_jornada->close();

    // Busca agendamentos existentes
    $stmt_agendados = $conexao->prepare("SELECT data_hora_agendamento FROM agendamentos WHERE id_medico = ? AND data_hora_agendamento BETWEEN ? AND ?");
    $stmt_agendados->bind_param("iss", $id_medico_atual, $start_date_str, $end_date_str);
    $stmt_agendados->execute();
    $horarios_ocupados = [];
    $resultado_agendados = $stmt_agendados->get_result();
    while($row = $resultado_agendados->fetch_assoc()) {
        $horarios_ocupados[] = $row['data_hora_agendamento'];
    }
    $stmt_agendados->close();

    // Gera slots
    $inicio_periodo = new DateTime($start_date_str);
    $fim_periodo = new DateTime($end_date_str);
    $intervalo_dia = new DateInterval('P1D');
    $periodo_dias = new DatePeriod($inicio_periodo, $intervalo_dia, $fim_periodo);

    foreach ($periodo_dias as $dia) {
        $dia_semana_num = $dia->format('N') + 1;
        if ($dia_semana_num > 7) $dia_semana_num = 1;

        if (isset($jornada_semanal[$dia_semana_num])) {
            $hora_inicio_jornada = new DateTime($dia->format('Y-m-d') . ' ' . $jornada_semanal[$dia_semana_num]['hora_inicio']);
            $hora_fim_jornada = new DateTime($dia->format('Y-m-d') . ' ' . $jornada_semanal[$dia_semana_num]['hora_fim']);

            while ($hora_inicio_jornada < $hora_fim_jornada) {
                $slot_formatado = $hora_inicio_jornada->format('Y-m-d H:i:s');
                if (!in_array($slot_formatado, $horarios_ocupados)) {
                    $eventos[] = [
                        'title' => $buscarTodosMedicos ? "Dr(a). " . $nome_medico . " - Disponível" : 'Disponível',
                        'start' => $hora_inicio_jornada->format('Y-m-d\TH:i:s'),
                        'backgroundColor' => $cor_medico,
                        'borderColor' => $cor_medico
                    ];
                }
                $hora_inicio_jornada->add(new DateInterval('PT' . $duracao_slot . 'M'));
            }
        }
    }
}

$conexao->close();
echo json_encode($eventos);
?>