<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['medico_id'])) {
    echo json_encode(['error' => 'Acesso no autorizado']);
    exit;
}

require_once '../conexao.php';

$idMedico = $_SESSION['medico_id'];

// ATUALIZAO: Adicionamos 'ordem_manual ASC'  clusula ORDER BY
$sql = "SELECT 
            f.id as id_fila,
            p.nome_completo as nome_paciente,
            f.hora_chegada,
            f.status_fila,
            f.ordem_prioridade
        FROM 
            fila_espera f
        JOIN 
            agendamentos a ON f.id_agendamento = a.id
        JOIN
            pacientes p ON a.id_paciente = p.id
        WHERE 
            f.id_medico = ? AND f.status_fila IN ('Aguardando', 'Chamado', 'Em Atendimento')
        ORDER BY 
            f.ordem_prioridade DESC, f.ordem_manual ASC, f.hora_chegada ASC";

$stmt = $conexao->prepare($sql);
$stmt->bind_param("i", $idMedico);
$stmt->execute();
$resultado = $stmt->get_result();
$fila = $resultado->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conexao->close();

echo json_encode($fila);
?>