<?php
header('Content-Type: application/json');
require_once '../conexao.php';

$termo_busca = $_GET['termo'] ?? '';
$hoje = date('Y-m-d');

$sql = "SELECT 
            a.id, 
            a.data_hora_agendamento,
            a.check_in_realizado,
            p.nome_completo as nome_paciente,
            m.nome_completo as nome_medico
        FROM 
            agendamentos a
        JOIN 
            pacientes p ON a.id_paciente = p.id
        JOIN 
            medicos m ON a.id_medico = m.id
        WHERE 
            DATE(a.data_hora_agendamento) = ? 
            AND p.nome_completo LIKE ?
        ORDER BY
            a.data_hora_agendamento ASC";

$stmt = $conexao->prepare($sql);
$termo_like = "%" . $termo_busca . "%";
$stmt->bind_param("ss", $hoje, $termo_like);
$stmt->execute();
$resultado = $stmt->get_result();
$agendamentos = $resultado->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conexao->close();

echo json_encode($agendamentos);
?>