<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['medico_id'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado.']);
    exit;
}

require_once '../conexao.php';

$dados = json_decode(file_get_contents('php://input'), true);
$idFila = $dados['id_fila'] ?? 0;
$novoStatus = $dados['novo_status'] ?? '';
$idMedicoLogado = $_SESSION['medico_id'];

if ($idFila === 0 || !in_array($novoStatus, ['Chamado', 'Em Atendimento', 'Atendido'])) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
    exit;
}

$conexao->begin_transaction();
try {
    $hora_atual = date('Y-m-d H:i:s');
    $coluna_hora = '';
    $mensagem_sucesso = '';

    switch ($novoStatus) {
        case 'Chamado':
            $coluna_hora = 'hora_chamada';
            $mensagem_sucesso = 'Paciente chamado com sucesso!';

            // Insere o registro na tabela de chamadas da TV
            $sql_info = "SELECT p.nome_completo, c.numero_sala FROM fila_espera f 
                         JOIN agendamentos a ON f.id_agendamento = a.id
                         JOIN pacientes p ON a.id_paciente = p.id
                         JOIN consultorios c ON f.id_consultorio = c.id
                         WHERE f.id = ? AND f.id_medico = ?";
            $stmt_info = $conexao->prepare($sql_info);
            $stmt_info->bind_param("ii", $idFila, $idMedicoLogado);
            $stmt_info->execute();
            $info = $stmt_info->get_result()->fetch_assoc();
            
            if ($info) {
                $stmt_tv = $conexao->prepare("INSERT INTO chamadas_tv (nome_paciente, numero_consultorio) VALUES (?, ?)");
                $stmt_tv->bind_param("ss", $info['nome_completo'], $info['numero_sala']);
                $stmt_tv->execute();
            }
            break;
        case 'Em Atendimento':
            // Não precisamos atualizar nenhuma coluna de hora específica aqui, apenas o status.
            // A hora_chamada já foi registrada.
            $mensagem_sucesso = 'Atendimento iniciado.';
            break;
        case 'Atendido':
            $coluna_hora = 'hora_fim_atendimento';
            $mensagem_sucesso = 'Atendimento finalizado com sucesso.';
            break;
    }

    $sql_update = "UPDATE fila_espera SET status_fila = ?";
    if (!empty($coluna_hora)) {
        $sql_update .= ", $coluna_hora = ?";
        $stmt_update = $conexao->prepare($sql_update . " WHERE id = ? AND id_medico = ?");
        $stmt_update->bind_param("ssii", $novoStatus, $hora_atual, $idFila, $idMedicoLogado);
    } else {
        $stmt_update = $conexao->prepare($sql_update . " WHERE id = ? AND id_medico = ?");
        $stmt_update->bind_param("sii", $novoStatus, $idFila, $idMedicoLogado);
    }
    
    $stmt_update->execute();
    
    $conexao->commit();
    echo json_encode(['success' => true, 'message' => $mensagem_sucesso]);

} catch (Exception $e) {
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => 'Erro ao atualizar status: ' . $e->getMessage()]);
}

$conexao->close();
?>