<?php
$titulo_pagina = "Gerenciar Pacientes";
include_once './_template/header.php';
require_once '../conexao.php';

// Lógica da busca
$termo_busca = $_GET['busca'] ?? '';
$pacientes = [];

if (!empty($termo_busca)) {
    // CORREÇÃO NO PHP: Também limpamos o termo de busca aqui por segurança.
    $termo_limpo = preg_replace('/[^a-zA-Z0-9]/', '', $termo_busca);

    $sql = "SELECT id, nome_completo, cpf, telefone_contato, cidade, estado 
            FROM pacientes 
            WHERE 
                nome_completo LIKE ? OR 
                REPLACE(REPLACE(cpf, '.', ''), '-', '') LIKE ? OR 
                REPLACE(REPLACE(REPLACE(telefone_contato, '(', ''), ') ', ''), '-', '') LIKE ?
            ORDER BY nome_completo
            LIMIT 50";
    
    $stmt = $conexao->prepare($sql);
    $termo_like = "%" . $termo_limpo . "%";
    $nome_like = "%" . $termo_busca . "%"; // Para o nome, mantemos a busca original com espaços
    $stmt->bind_param("sss", $nome_like, $termo_like, $termo_like);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $pacientes = $resultado->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Gerenciar Pacientes</h1>
    <a href="pacientes_adicionar.php" class="btn btn-success"><i class="bi bi-plus-lg"></i> Adicionar Paciente</a>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <form method="GET" class="row g-3 align-items-center" id="formBusca">
            <div class="col-md-10">
                <input type="text" id="busca" name="busca" class="form-control" placeholder="Digite Nome, CPF ou Telefone para buscar..." value="<?php echo htmlspecialchars($termo_busca); ?>">
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100">Buscar</button>
            </div>
        </form>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" width="100%">
                <thead>
                    <tr>
                        <th>Nome Completo</th>
                        <th>CPF</th>
                        <th>Telefone</th>
                        <th>Cidade/UF</th>
                        <th class="text-center">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($pacientes)): foreach($pacientes as $paciente): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($paciente['nome_completo']); ?></td>
                            <td><?php echo htmlspecialchars($paciente['cpf']); ?></td>
                            <td><?php echo htmlspecialchars($paciente['telefone_contato']); ?></td>
                            <td>
                                <?php 
                                $localizacao = '';
                                if (!empty($paciente['cidade'])) $localizacao .= $paciente['cidade'];
                                if (!empty($paciente['estado'])) $localizacao .= ' - ' . $paciente['estado'];
                                echo htmlspecialchars($localizacao); 
                                ?>
                            </td>
                            <td class="text-center">
                                <a href="agendamento_admin.php?paciente_id=<?php echo $paciente['id']; ?>" class="btn btn-success btn-sm" title="Agendar Consulta"><i class="bi bi-calendar-plus-fill"></i></a>
                                <a href="pacientes_editar.php?id=<?php echo $paciente['id']; ?>" class="btn btn-warning btn-sm" title="Ver / Editar Cadastro"><i class="bi bi-pencil-fill"></i></a>
                                <a href="pacientes_prontuario.php?id=<?php echo $paciente['id']; ?>" class="btn btn-info btn-sm" title="Ver Histórico/Prontuário"><i class="bi bi-file-earmark-text-fill"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; else: ?>
                        <tr><td colspan="5" class="text-center"><?php echo !empty($termo_busca) ? 'Nenhum paciente encontrado.' : 'Use a busca acima para encontrar um paciente.'; ?></td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const formBusca = document.getElementById('formBusca');
    const inputBusca = document.getElementById('busca');

    formBusca.addEventListener('submit', function(e) {
        // Pega o valor digitado pelo usuário
        let valorBusca = inputBusca.value;

        // Se o valor parece ser um telefone ou CPF (contém números), limpa a máscara
        if (/\d/.test(valorBusca)) {
            // Remove tudo que não for número
            inputBusca.value = valorBusca.replace(/\D/g, '');
        }
        // Se for um nome, deixa como está (com espaços, etc)
    });
});
</script>


<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>