<?php
$titulo_pagina = "Jornada de Trabalho dos Médicos";
include_once './_template/header.php';
require_once '../conexao.php';

// Busca médicos ativos para o dropdown
$medicos = $conexao->query("SELECT id, nome_completo FROM medicos WHERE ativo = 1 ORDER BY nome_completo")->fetch_all(MYSQLI_ASSOC);
$medico_selecionado_id = $_GET['medico_id'] ?? null;
$horarios_medico = [];

if ($medico_selecionado_id) {
    $stmt = $conexao->prepare("SELECT dia_semana, hora_inicio, hora_fim FROM horarios_trabalho WHERE id_medico = ?");
    $stmt->bind_param("i", $medico_selecionado_id);
    $stmt->execute();
    $resultado = $stmt->get_result();
    while ($row = $resultado->fetch_assoc()) {
        $horarios_medico[$row['dia_semana']] = ['inicio' => $row['hora_inicio'], 'fim' => $row['hora_fim']];
    }
    $stmt->close();
}
$dias_semana = [2 => 'Segunda-feira', 3 => 'Terça-feira', 4 => 'Quarta-feira', 5 => 'Quinta-feira', 6 => 'Sexta-feira', 7 => 'Sábado', 1 => 'Domingo'];
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Definir Jornada de Trabalho</h1>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <form method="GET" class="row g-3 align-items-center">
            <div class="col-auto">
                <label for="medico_id" class="form-label">Selecione o Médico:</label>
            </div>
            <div class="col-md-5">
                <select name="medico_id" id="medico_id" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Escolha um médico --</option>
                    <?php foreach ($medicos as $medico): ?>
                        <option value="<?php echo $medico['id']; ?>" <?php echo ($medico_selecionado_id == $medico['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($medico['nome_completo']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </form>
    </div>
    
    <?php if ($medico_selecionado_id): ?>
    <div class="card-body">
        <form action="horarios_acao.php" method="POST">
            <input type="hidden" name="id_medico" value="<?php echo $medico_selecionado_id; ?>">
            <p>Preencha os horários de início e fim para cada dia de trabalho. Deixe em branco os dias em que o médico não atende.</p>
            
            <?php foreach ($dias_semana as $num_dia => $nome_dia): ?>
                <div class="row g-3 align-items-center mb-3 p-2 bg-light rounded">
                    <div class="col-md-3">
                        <label class="form-check-label fw-bold"><?php echo $nome_dia; ?></label>
                    </div>
                    <div class="col-md-4">
                        <label for="inicio_<?php echo $num_dia; ?>" class="form-label">Início</label>
                        <input type="time" class="form-control" id="inicio_<?php echo $num_dia; ?>" name="horarios[<?php echo $num_dia; ?>][inicio]" value="<?php echo $horarios_medico[$num_dia]['inicio'] ?? ''; ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="fim_<?php echo $num_dia; ?>" class="form-label">Fim</label>
                        <input type="time" class="form-control" id="fim_<?php echo $num_dia; ?>" name="horarios[<?php echo $num_dia; ?>][fim]" value="<?php echo $horarios_medico[$num_dia]['fim'] ?? ''; ?>">
                    </div>
                </div>
            <?php endforeach; ?>

            <div class="d-flex justify-content-end mt-4">
                <button type="submit" class="btn btn-primary">Salvar Jornada de Trabalho</button>
            </div>
        </form>
    </div>
    <?php endif; ?>
</div>

<?php include_once './_template/footer.php'; ?>