<?php
$titulo_pagina = "Gerenciar Consultórios";
include_once './_template/header.php';
require_once '../conexao.php';

$sql = "SELECT id, numero_sala, descricao FROM consultorios ORDER BY numero_sala";
$resultado = $conexao->query($sql);
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">Consultórios</h1>
    <a href="consultorios_adicionar.php" class="btn btn-success">
        <i class="bi bi-plus-lg"></i> Adicionar Novo
    </a>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success_message']; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['success_message']); ?>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Lista de Consultórios Cadastrados</h6></div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nome/Número da Sala</th>
                        <th>Descrição</th>
                        <th class="text-center">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resultado->num_rows > 0): ?>
                        <?php while($consultorio = $resultado->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $consultorio['id']; ?></td>
                                <td><?php echo htmlspecialchars($consultorio['numero_sala']); ?></td>
                                <td><?php echo htmlspecialchars($consultorio['descricao']); ?></td>
                                <td class="text-center">
                                    <a href="consultorios_editar.php?id=<?php echo $consultorio['id']; ?>" class="btn btn-warning btn-sm"><i class="bi bi-pencil-fill"></i></a>
                                    <a href="consultorios_acao.php?acao=excluir&id=<?php echo $consultorio['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Tem certeza?');"><i class="bi bi-trash-fill"></i></a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="4" class="text-center">Nenhum consultório encontrado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>