<?php
$titulo_pagina = "Agenda da Clínica";
include_once './_template/header.php';
require_once '../conexao.php';
$medicos = $conexao->query("SELECT id, nome_completo FROM medicos WHERE ativo = 1 ORDER BY nome_completo")->fetch_all(MYSQLI_ASSOC);
$filtro_medico_id = $_GET['medico_id'] ?? 'todos';
?>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
<style>
    #agenda-container, .form-select, .btn, .fc { font-family: 'Roboto', sans-serif !important; }
    #calendario { height: 80vh; }
    .add-appointment-btn { /* Estilo do botão + */ }
    .medico-legend {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin: 10px 0;
        padding: 10px;
        background: #f8f9fa;
        border-radius: 5px;
    }
    .medico-legend-item {
        display: flex;
        align-items: center;
        gap: 5px;
        padding: 5px 10px;
        border-radius: 4px;
        font-size: 0.9em;
    }
    .medico-legend-color {
        width: 15px;
        height: 15px;
        border-radius: 3px;
    }
    /* Melhorias de layout para o calendário */
    .fc .fc-toolbar-title {
        font-family: 'Roboto', sans-serif !important;
        font-size: 1.5rem;
        font-weight: 700;
        color: #222;
    }
    .fc .fc-col-header-cell-cushion {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        padding: 8px 0 0 8px;
        font-family: 'Roboto', sans-serif !important;
        background: transparent;
    }
    .fc .fc-custom-day-header {
        font-size: 0.8em !important;
        color: #666 !important;
        font-weight: 400 !important;
        margin-bottom: 2px !important;
        text-decoration: none !important;
        background: none !important;
    }
    .fc .fc-custom-day-date-row {
        display: flex;
        flex-direction: row;
        align-items: baseline;
        gap: 2px;
    }
    .fc .fc-custom-day-number {
        font-size: 2.1em;
        font-weight: 400 !important;
        color: #222;
        line-height: 1;
        display: inline-block;
        text-decoration: none !important;
    }
    .fc .fc-custom-day-month {
        font-size: 0.85em !important;
        color: #bbb !important;
        font-weight: 300 !important;
        margin-left: 2px !important;
        vertical-align: middle !important;
        letter-spacing: 0.5px !important;
        text-decoration: none !important;
        background: none !important;
    }
    .fc .fc-daygrid-day-number, .fc .fc-timegrid-axis-cushion {
        font-family: 'Roboto', sans-serif !important;
        font-size: 1.2rem;
        font-weight: 400;
        color: #222;
        padding: 0 0 0 8px;
    }
    .fc .fc-daygrid-day-top {
        flex-direction: column;
        align-items: flex-start;
        padding-left: 8px;
        padding-top: 8px;
    }
    .fc .fc-daygrid-day {
        background: #fff;
        border-radius: 8px;
        margin: 2px;
    }
    .fc .fc-scrollgrid-section-header > th {
        background: #f8f9fa;
        border: none;
    }
    .fc .fc-scrollgrid-section-body > td {
        background: #fff;
        border: none;
    }
    .fc .fc-timegrid-slot-label {
        font-family: 'Roboto', sans-serif !important;
        font-size: 1rem;
        font-weight: 400;
        color: #888;
        padding-left: 8px;
    }
    .fc .fc-timegrid-slot {
        border-color: #f0f0f0;
    }
    .fc .fc-timegrid-axis-cushion {
        color: #888;
        font-size: 1rem;
        font-weight: 400;
    }
    .fc .fc-day-today {
        background: #e3f2fd !important;
    }
    .fc .fc-daygrid-day.fc-day-today {
        background: #e3f2fd !important;
    }
    .fc .fc-daygrid-day-number {
        color: #222;
        font-weight: 700;
    }
    .fc .fc-daygrid-day.fc-day-past {
        opacity: 0.7;
    }
    /* Remove bordas extras */
    .fc .fc-scrollgrid, .fc .fc-scrollgrid-section {
        border: none !important;
    }
    /* Forçar número do dia com peso 300, sem underline, mesmo se for link */
    .fc .fc-col-header-cell .fc-custom-day-number,
    .fc .fc-col-header-cell .fc-custom-day-number *,
    .fc .fc-col-header-cell-cushion .fc-custom-day-number,
    .fc .fc-col-header-cell-cushion .fc-custom-day-number *,
    .fc .fc-col-header-cell a .fc-custom-day-number,
    .fc .fc-col-header-cell a .fc-custom-day-number * {
        font-family: 'Roboto', sans-serif !important;
        font-weight: 300 !important;
        font-variation-settings: 'wght' 300 !important;
        color: #222 !important;
        text-decoration: none !important;
        background: none !important;
        line-height: 1 !important;
        display: inline-block !important;
        font-size: 1.5em !important;
    }
    .fc .fc-custom-day-number, .fc .fc-custom-day-number a {
        font-size: 2.1em !important;
        font-weight: 400 !important;
        color: #222 !important;
        line-height: 1 !important;
        display: inline-block !important;
        text-decoration: none !important;
        background: none !important;
    }
    .fc .fc-custom-day-month, .fc .fc-custom-day-month a {
        font-size: 0.85em !important;
        color: #bbb !important;
        font-weight: 300 !important;
        margin-left: 2px !important;
        vertical-align: middle !important;
        letter-spacing: 0.5px !important;
        text-decoration: none !important;
        background: none !important;
    }
    .fc .fc-custom-day-header, .fc .fc-custom-day-header a {
        font-size: 0.8em !important;
        color: #666 !important;
        font-weight: 400 !important;
        margin-bottom: 2px !important;
        text-decoration: none !important;
        background: none !important;
    }
</style>

<div id="agenda-container">
    <div class="card shadow mb-4">
        <div class="card-body">
            <form id="filter-form" action="agenda_geral.php" method="GET" class="d-flex align-items-center">
                <label for="medico_filtro" class="me-2 fw-bold">Médico:</label>
                <select name="medico_id" id="medico_filtro" class="form-select" style="width: 250px;" onchange="this.form.submit()">
                    <option value="todos">Todos os médicos</option>
                    <?php foreach ($medicos as $medico): ?>
                        <option value="<?php echo $medico['id']; ?>" <?php echo ($filtro_medico_id == $medico['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($medico['nome_completo']); ?></option>
                    <?php endforeach; ?>
                </select>
            </form>
            
            <?php if ($filtro_medico_id === 'todos'): ?>
            <div class="medico-legend" id="medico-legend">
                <!-- A legenda será preenchida via JavaScript -->
            </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="card shadow"><div class="card-body"><div id="calendario"></div></div></div>
</div>

<button class="add-appointment-btn" id="btnAddAppointment"><i class="bi bi-plus-lg"></i></button>

<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js'></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const calendarioEl = document.getElementById('calendario');
    const filtroMedicoSelect = document.getElementById('medico_filtro');
    const medicoLegend = document.getElementById('medico-legend');
    
    // Array de cores para os médicos (deve corresponder ao array no PHP)
    const cores = [
        '#28a745', // Verde
        '#007bff', // Azul
        '#dc3545', // Vermelho
        '#ffc107', // Amarelo
        '#17a2b8', // Azul claro
        '#6610f2', // Roxo
        '#fd7e14', // Laranja
        '#20c997', // Verde água
        '#e83e8c', // Rosa
        '#6f42c1'  // Roxo escuro
    ];
    
    // Função para criar a legenda de médicos
    function criarLegendaMedicos() {
        if (!medicoLegend) return;
        
        const medicos = <?php echo json_encode($medicos); ?>;
        medicoLegend.innerHTML = '';
        
        medicos.forEach((medico, index) => {
            const cor = cores[index % cores.length];
            const item = document.createElement('div');
            item.className = 'medico-legend-item';
            item.style.backgroundColor = cor + '20'; // Cor com transparência
            item.style.border = '1px solid ' + cor;
            
            const colorBox = document.createElement('div');
            colorBox.className = 'medico-legend-color';
            colorBox.style.backgroundColor = cor;
            
            const nome = document.createElement('span');
            nome.textContent = 'Dr(a). ' + medico.nome_completo;
            
            item.appendChild(colorBox);
            item.appendChild(nome);
            medicoLegend.appendChild(item);
        });
    }
    
    // Criar a legenda se estiver na visualização de todos os médicos
    if (medicoLegend) {
        criarLegendaMedicos();
    }

    const calendar = new FullCalendar.Calendar(calendarioEl, {
        locale: 'pt-br',
        initialView: 'timeGridWeek',
        headerToolbar: { left: 'prev,next today', center: 'title', right: 'dayGridMonth,timeGridWeek,timeGridDay' },
        buttonText: { today: 'Hoje', month: 'Mês', week: 'Semana', day: 'Dia' },
        firstDay: 1, 
        allDaySlot: false,
        nowIndicator: true,
        scrollTime: new Date().toTimeString().substring(0, 5),
        slotDuration: '00:15:00',
        slotLabelInterval: '01:00:00',
        slotLabelFormat: {
            hour: '2-digit',
            minute: '2-digit',
            hour12: false,
            omitZeroMinute: false
        },
        dayHeaderContent: function(arg) {
            // arg.date é um objeto Date
            const diaSemana = arg.date.toLocaleDateString('pt-BR', { weekday: 'short' });
            const dia = arg.date.getDate().toString().padStart(2, '0');
            const mes = (arg.date.getMonth() + 1).toString().padStart(2, '0');
            return {
                html: `<span class='fc-custom-day-header'>${diaSemana.charAt(0).toUpperCase() + diaSemana.slice(1)}.</span><span class='fc-custom-day-date-row'><span class='fc-custom-day-number'>${dia}</span><span class='fc-custom-day-month'>/${mes}</span></span>`
            };
        },
        // MUDANÇA CRÍTICA: Usando a API que NÓS SABEMOS QUE FUNCIONA
        events: `../api/get_horarios.php?medico_id=<?php echo $filtro_medico_id; ?>`,
    });
    calendar.render();
    
    document.getElementById('btnAddAppointment').addEventListener('click', function() { 
        // Esta funcionalidade será o nosso próximo passo
        alert('Funcionalidade de adicionar agendamento será implementada a seguir.');
    });
});
</script>

<?php 
$conexao->close();
include_once './_template/footer.php'; 
?>