<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Se a função não existir, defina-a aqui
if (!function_exists('loadOffices')) {
    function loadOffices() {
        $offices_file = BASE_PATH . '/data/offices.json';
        if (!file_exists($offices_file)) {
            return [];
        }
        return json_decode(file_get_contents($offices_file), true) ?: [];
    }
}

// Carregar médicos
function loadDoctors() {
    $doctors_file = BASE_PATH . '/data/doctors.json';
    if (!file_exists($doctors_file)) {
        return [];
    }
    return json_decode(file_get_contents($doctors_file), true) ?: [];
}

$doctors = loadDoctors();
$offices = loadOffices();

// Processar exclusão de médico
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_doctor_id'])) {
    $doctors = array_filter($doctors, function($doctor) {
        return $doctor['id'] !== $_POST['delete_doctor_id'];
    });
    
    $doctors_file = BASE_PATH . '/data/doctors.json';
    file_put_contents($doctors_file, json_encode($doctors, JSON_PRETTY_PRINT));
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento de Médicos</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <div class="container mx-auto px-4 py-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold">Médicos Cadastrados</h1>
            <div class="flex space-x-4">
                <a href="cadastro.php" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded">
                    Novo Médico
                </a>
                <a href="../logout.php" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded">
                    Saída
                </a>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <table class="w-full">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="py-2 px-4 text-left">Nome</th>
                        <th class="py-2 px-4 text-left">CRM</th>
                        <th class="py-2 px-4 text-left">Consultório</th>
                        <th class="py-2 px-4 text-left">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($doctors as $doctor): ?>
                        <tr class="border-b">
                            <td class="py-2 px-4"><?= htmlspecialchars($doctor['name']) ?></td>
                            <td class="py-2 px-4"><?= htmlspecialchars($doctor['crm']) ?></td>
                            <td class="py-2 px-4">
                                <?php 
                                $office = array_filter($offices, function($off) use ($doctor) {
                                    return $off['id'] === $doctor['office_id'];
                                });
                                echo !empty($office) ? htmlspecialchars(reset($office)['name']) : 'Não definido';
                                ?>
                            </td>
                            <td class="py-2 px-4">
                                <div class="flex space-x-2">
                                    <a href="cadastro.php?id=<?= $doctor['id'] ?>" 
                                       class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-1 px-3 rounded">
                                        Editar
                                    </a>
                                    <form method="post" class="inline" onsubmit="return confirm('Tem certeza que deseja excluir este médico?');">
                                        <input type="hidden" name="delete_doctor_id" value="<?= $doctor['id'] ?>">
                                        <button type="submit" class="bg-red-500 hover:bg-red-600 text-white font-bold py-1 px-3 rounded">
                                            Excluir
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($doctors)): ?>
                        <tr>
                            <td colspan="4" class="text-center py-4 text-gray-500">
                                Nenhum médico cadastrado
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>