<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Chamada de Pacientes</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #004080;
            color: white;
            text-align: center;
            transition: background-color 0.5s ease;
        }
        .patient-called {
            background-color: red !important;
        }
        #patient-name {
            font-size: 10vw;
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
    </style>
</head>
<body>
    <div id="patient-display">
        <h1 id="patient-name">Aguardando Chamada</h1>
    </div>
    
    <!-- Adicionar elemento de udio -->
    <audio id="patient-alert">
        <source src="alert.mp3" type="audio/mpeg">
        Seu navegador n00o suporta reprodu0400o de udio.
    </audio>

    <script>
        function fetchNextPatient() {
            fetch('get_next_patient.php')
                .then(response => response.json())
                .then(data => {
                    const patientNameElement = document.getElementById('patient-name');
                    const bodyElement = document.body;
                    const audioElement = document.getElementById('patient-alert');
                    
                    if (data.name) {
                        // Reproduzir udio de alerta
                        audioElement.play();
                        
                        // Quando o udio terminar, falar o nome do paciente
                        audioElement.onended = () => {
                            const synth = window.speechSynthesis;
                            const utterance = new SpeechSynthesisUtterance(data.name);
                            utterance.lang = "pt-BR";
                            synth.speak(utterance);
                        };
                        
                        // Mostrar nome do paciente
                        patientNameElement.textContent = data.name;
                        bodyElement.classList.add('patient-called');
                        
                        // Voltar ao estado inicial aps 10 segundos
                        setTimeout(() => {
                            patientNameElement.textContent = 'Aguardando Chamada';
                            bodyElement.classList.remove('patient-called');
                        }, 10000);
                    }
                })
                .catch(error => {
                    console.error('Erro ao buscar paciente:', error);
                });
        }
        
        // Buscar paciente a cada 5 segundos
    setInterval(fetchNextPatient, 3000);

    </script>
</body>
</html>
